/*
 * Decompiled with CFR 0.152.
 */
package cityofskytcd.chineseworkshop.item;

import cityofskytcd.chineseworkshop.CWConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DebugStickItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.item.ModItem;

public class SafeDebugStickItem
extends DebugStickItem {
    public SafeDebugStickItem(Item.Properties builder) {
        super(builder);
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            this.handleClick(player, state, (IWorld)worldIn, pos, false, player.func_184586_b(Hand.MAIN_HAND));
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity playerentity = context.func_195999_j();
        World world = context.func_195991_k();
        if (!world.field_72995_K && playerentity != null) {
            BlockPos blockpos = context.func_195995_a();
            this.handleClick(playerentity, world.func_180495_p(blockpos), (IWorld)world, blockpos, true, context.func_195996_i());
        }
        return ActionResultType.SUCCESS;
    }

    private void handleClick(PlayerEntity player, BlockState state, IWorld worldIn, BlockPos pos, boolean rightClick, ItemStack stack) {
        if (SafeDebugStickItem.canApplyOn(state)) {
            Block block = state.func_177230_c();
            StateContainer statecontainer = block.func_176194_O();
            ArrayList collection = Lists.newArrayList((Iterable)statecontainer.func_177623_d());
            collection.remove(BlockStateProperties.field_208198_y);
            String s = Registry.field_212618_g.func_177774_c((Object)block).toString();
            if (collection.isEmpty()) {
                SafeDebugStickItem.sendMessage(player, (ITextComponent)new TranslationTextComponent(Items.field_196180_eI.func_77658_a() + ".empty", new Object[]{s}));
            } else {
                CompoundNBT compoundnbt = stack.func_190925_c("DebugProperty");
                String s1 = compoundnbt.func_74779_i(s);
                IProperty iproperty = statecontainer.func_185920_a(s1);
                if (rightClick) {
                    if (iproperty == null) {
                        iproperty = (IProperty)collection.iterator().next();
                    }
                    BlockState blockstate = SafeDebugStickItem.cycleProperty(state, iproperty, player.func_70093_af());
                    worldIn.func_180501_a(pos, blockstate, 18);
                    SafeDebugStickItem.sendMessage(player, (ITextComponent)new TranslationTextComponent(Items.field_196180_eI.func_77658_a() + ".update", new Object[]{iproperty.func_177701_a(), SafeDebugStickItem.func_195957_a(blockstate, iproperty)}));
                } else {
                    iproperty = SafeDebugStickItem.getAdjacentValue(collection, iproperty, player.func_70093_af());
                    String s2 = iproperty.func_177701_a();
                    compoundnbt.func_74778_a(s, s2);
                    SafeDebugStickItem.sendMessage(player, (ITextComponent)new TranslationTextComponent(Items.field_196180_eI.func_77658_a() + ".select", new Object[]{s2, SafeDebugStickItem.func_195957_a(state, iproperty)}));
                }
            }
        } else {
            SafeDebugStickItem.sendMessage(player, (ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".unsupported", new Object[0]));
        }
    }

    public static boolean canApplyOn(BlockState state) {
        Block block = state.func_177230_c();
        if (((List)CWConfig.allowedMods.get()).contains(block.getRegistryName().func_110624_b())) {
            return true;
        }
        String className = block.getClass().getName();
        return ((List)CWConfig.allowedClasses.get()).contains(className);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ModItem.addTip((ItemStack)stack, (World)worldIn, tooltip, (ITooltipFlag)flagIn);
    }

    private static <T extends Comparable<T>> BlockState cycleProperty(BlockState state, IProperty<T> propertyIn, boolean backwards) {
        return (BlockState)state.func_206870_a(propertyIn, SafeDebugStickItem.getAdjacentValue(propertyIn.func_177700_c(), state.func_177229_b(propertyIn), backwards));
    }

    private static <T> T getAdjacentValue(Iterable<T> p_195959_0_, @Nullable T p_195959_1_, boolean p_195959_2_) {
        return (T)(p_195959_2_ ? Util.func_195648_b(p_195959_0_, p_195959_1_) : Util.func_195647_a(p_195959_0_, p_195959_1_));
    }

    private static void sendMessage(PlayerEntity player, ITextComponent text) {
        ((ServerPlayerEntity)player).func_195395_a(text, ChatType.GAME_INFO);
    }

    private static <T extends Comparable<T>> String func_195957_a(BlockState state, IProperty<T> propertyIn) {
        return propertyIn.func_177702_a(state.func_177229_b(propertyIn));
    }
}

