/*
 * Decompiled with CFR 0.152.
 */
package cityofskytcd.chineseworkshop.library;

import cityofskytcd.chineseworkshop.BlockModule;
import cityofskytcd.chineseworkshop.CW;
import cityofskytcd.chineseworkshop.TextureModule;
import cityofskytcd.chineseworkshop.library.Selection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import snownee.kiwi.Kiwi;

public class Selections {
    private static final Set<Item> allItems = Sets.newHashSet();
    public static final List<Selection> SELECTIONS = Lists.newLinkedList();

    private Selections() {
    }

    public static void init() {
        boolean retexture = Kiwi.isLoaded((ResourceLocation)new ResourceLocation("chineseworkshop", "retexture"));
        Selections.addSelection((IItemProvider)BlockModule.BLACK_TILE_ROOF, new IItemProvider[]{BlockModule.BLACK_TILE_ROOF_J, BlockModule.BLACK_TILE_ROOF_SLAB, BlockModule.BLACK_TILE_ROOF_SLAB_TOP});
        Selections.addSelection((IItemProvider)BlockModule.BLACK_TILE_ROOF_RIDGE, new IItemProvider[]{BlockModule.BLACK_TILE_ROOF_RIDGE_J, BlockModule.BLACK_TILE_ROOF_RIDGE_TOP});
        if (retexture) {
            Selections.addSelection(true, (IItemProvider)TextureModule.BLACK_TILE_ROOF_DYN, new IItemProvider[]{TextureModule.BLACK_TILE_ROOF_J_DYN, TextureModule.BLACK_TILE_ROOF_SLAB_DYN, TextureModule.BLACK_TILE_ROOF_SLAB_TOP_DYN});
            Selections.addSelection(true, (IItemProvider)TextureModule.BLACK_TILE_ROOF_RIDGE_DYN, new IItemProvider[]{TextureModule.BLACK_TILE_ROOF_RIDGE_J_DYN, TextureModule.BLACK_TILE_ROOF_RIDGE_TOP_DYN});
        }
        Selections.addSelection((IItemProvider)BlockModule.THATCH_ROOF, new IItemProvider[]{BlockModule.THATCH_ROOF_SLAB, BlockModule.THATCH_ROOF_SLAB_TOP});
        Selections.addSelection((IItemProvider)BlockModule.THATCH_ROOF_RIDGE, new IItemProvider[]{BlockModule.THATCH_ROOF_RIDGE_TOP});
    }

    public static void addSelection(IItemProvider mainItem, IItemProvider ... subItems) {
        Selections.addSelection(false, mainItem, subItems);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void addSelection(boolean hide, IItemProvider mainItem, IItemProvider ... subItems) {
        Item main = mainItem.func_199767_j();
        List<Item> items = ImmutableList.copyOf((Object[])subItems).stream().map(IItemProvider::func_199767_j).collect(Collectors.toList());
        if (!allItems.contains(main)) {
            if (!items.stream().anyMatch(allItems::contains)) {
                SELECTIONS.add(new Selection(main, items, hide));
                allItems.add(main);
                allItems.addAll(items);
                return;
            }
        }
        CW.logger.error("Try to add an existent IItemProvider to selections, skipped");
    }

    @Nullable
    public static Selection find(ItemStack stack) {
        return Selections.find((IItemProvider)stack.func_77973_b());
    }

    @Nullable
    public static Selection find(IItemProvider provider) {
        Optional<Selection> result;
        Item item = provider.func_199767_j();
        if (allItems.contains(item) && (result = SELECTIONS.stream().filter(s -> s.matches(item)).findFirst()).isPresent()) {
            return result.get();
        }
        return null;
    }

    public static boolean contains(Item item) {
        return allItems.contains(item);
    }
}

