/*
 * Decompiled with CFR 0.152.
 */
package cityofskytcd.chineseworkshop.event;

import cityofskytcd.chineseworkshop.library.Selection;
import cityofskytcd.chineseworkshop.library.Selections;
import cityofskytcd.chineseworkshop.network.WheelMovePacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.crash.CrashReport;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class HudHandler {
    public static KeyBinding kbSelect = new KeyBinding("chineseworkshop.keybind.select", 342, "chineseworkshop.gui.keygroup");
    protected static boolean showGui = false;
    protected static boolean animating = false;
    private static float animationTick = 0.0f;
    private static float[] badgeProcess = new float[0];
    private static boolean[] keyMap = new boolean[8];

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getKey() >= 340 && event.getKey() <= 347 && event.getAction() < 2) {
            boolean bl = HudHandler.keyMap[event.getKey() - 340] = event.getAction() == 1;
        }
        if (mc.field_71462_r == null && mc.field_71439_g != null && mc.func_195544_aj() && kbSelect.func_151470_d()) {
            int code = kbSelect.getKey().func_197937_c();
            boolean f = code < 340 || code > 347;
            for (boolean pressed : keyMap) {
                if (!pressed) continue;
                if (f) {
                    return;
                }
                f = true;
            }
            ItemStack stack = mc.field_71439_g.func_184614_ca();
            if (!stack.func_190926_b() && Selections.contains(stack.func_77973_b())) {
                showGui = true;
                animating = true;
            }
        } else if (showGui && !kbSelect.func_151470_d()) {
            showGui = false;
            animating = true;
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseScrollEvent event) {
        if (showGui && event.getScrollDelta() != 0.0) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            ItemStack held = player.func_184614_ca();
            if (held.func_190926_b()) {
                showGui = false;
                return;
            }
            Selection selection = Selections.find(held);
            if (selection != null) {
                Item item = held.func_77973_b();
                for (int i = 0; i < selection.size(); ++i) {
                    if (!item.equals(selection.get(i))) continue;
                    i = (i + selection.size() + (event.getScrollDelta() < 0.0 ? -1 : 1)) % selection.size();
                    new WheelMovePacket(i).send();
                    ItemStack stack = new ItemStack((IItemProvider)selection.get(i));
                    stack.func_190920_e(held.func_190916_E());
                    stack.func_77982_d(held.func_77978_p());
                    player.func_184201_a(EquipmentSlotType.MAINHAND, stack);
                    break;
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void drawHudPost(RenderGameOverlayEvent.Post event) {
        if ((showGui || animating) && event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            ItemStack held = mc.field_71439_g.func_184614_ca();
            if (held.func_190926_b()) {
                return;
            }
            Selection selection = Selections.find(held);
            if (selection == null) {
                return;
            }
            float xStart = event.getWindow().func_198107_o() / 2;
            float yStart = event.getWindow().func_198087_p() / 2;
            float pTicks = mc.func_193989_ak();
            MatrixStack matrixstack = new MatrixStack();
            IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)xStart, (float)yStart, (float)0.0f);
            if (animating) {
                animationTick += pTicks * (float)(showGui ? 1 : -2);
                if ((animationTick = MathHelper.func_76131_a((float)animationTick, (float)0.0f, (float)9.0f)) == 9.0f) {
                    animating = false;
                } else {
                    if (!showGui && (double)animationTick < 0.01) {
                        animating = false;
                        RenderSystem.popMatrix();
                        buffer.func_228461_a_();
                        return;
                    }
                    double scale = Math.sqrt(animationTick) / 3.0;
                    RenderSystem.scaled((double)scale, (double)scale, (double)scale);
                }
            }
            HudHandler.drawBadge(mc, held, 0.0f, true, matrixstack, buffer);
            if (selection.size() < 2) {
                CrashReport crash = CrashReport.func_85055_a((Throwable)new Exception(), (String)"Number of options smaller than 2");
                mc.func_71404_a(crash);
            }
            float degPer = 360.0f / (float)selection.size();
            boolean matched = false;
            if (selection.size() != badgeProcess.length) {
                badgeProcess = new float[selection.size()];
            }
            for (int i = 0; i < selection.size(); ++i) {
                Item item = selection.get(i);
                RenderSystem.pushMatrix();
                float rad = (float)((double)((((float)i + (selection.size() % 2 == 0 ? 0.5f : 0.0f)) * degPer + 180.0f) / 180.0f) * Math.PI);
                RenderSystem.translated((double)(Math.sin(rad) * 60.0), (double)(Math.cos(rad) * 60.0), (double)0.0);
                RenderSystem.scaled((double)0.618, (double)0.618, (double)0.618);
                boolean match = !matched && item == held.func_77973_b();
                matched = matched || match;
                int n = i;
                badgeProcess[n] = badgeProcess[n] + (match ? pTicks : -pTicks);
                HudHandler.badgeProcess[i] = MathHelper.func_76131_a((float)badgeProcess[i], (float)0.0f, (float)10.0f);
                ItemStack stack = new ItemStack((IItemProvider)item);
                stack.func_77982_d(held.func_77978_p());
                HudHandler.drawBadge(mc, stack, badgeProcess[i], false, matrixstack, buffer);
                RenderSystem.popMatrix();
            }
            if (!matched) {
                CrashReport crash = CrashReport.func_85055_a((Throwable)new Exception(), (String)"Options do not contain item itself");
                mc.func_71404_a(crash);
            }
            RenderSystem.popMatrix();
        }
    }

    private static void drawCenteredString(FontRenderer fontRendererIn, String text, float x, float y) {
        fontRendererIn.func_175063_a(text, x - (float)(fontRendererIn.func_78256_a(text) / 2), y, 0xFFFFFF);
    }

    protected static void drawBadge(Minecraft mc, ItemStack stack, float color, boolean rotation, MatrixStack matrixstack, IRenderTypeBuffer.Impl buffer) {
        boolean flag;
        RenderSystem.enableBlend();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        color = (float)(Math.sin((color - 5.0f) / 5.0f) + 0.5);
        RenderSystem.color4f((float)(color * 0.1f), (float)(color * 0.5f), (float)(color * 0.9f), (float)0.3f);
        GL11.glBegin((int)6);
        GL11.glVertex2f((float)0.0f, (float)-30.0f);
        GL11.glVertex2f((float)-26.0f, (float)-15.0f);
        GL11.glVertex2f((float)-26.0f, (float)15.0f);
        GL11.glVertex2f((float)0.0f, (float)30.0f);
        GL11.glVertex2f((float)26.0f, (float)15.0f);
        GL11.glVertex2f((float)26.0f, (float)-15.0f);
        GL11.glEnd();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.shadeModel((int)7424);
        HudHandler.drawCenteredString(mc.field_71466_p, stack.func_200301_q().func_150254_d(), 0.0f, 8.0f);
        RenderSystem.pushMatrix();
        RenderSystem.scaled((double)1.5, (double)1.5, (double)1.5);
        IBakedModel bakedModel = mc.func_175599_af().func_184393_a(stack, null, null);
        boolean bl = flag = !bakedModel.func_230044_c_();
        if (flag) {
            RenderSystem.setupGuiFlatDiffuseLighting();
        }
        mc.func_175599_af().func_184391_a(null, stack, -8, -12);
        if (flag) {
            RenderSystem.setupGui3DDiffuseLighting();
        }
        RenderHelper.func_74518_a();
        buffer.func_228461_a_();
        RenderSystem.popMatrix();
    }

    @SubscribeEvent
    public static void drawHudPre(RenderGameOverlayEvent.Pre event) {
        if ((showGui || animating) && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        Item item = event.getItemStack().func_77973_b();
        if (Selections.contains(item)) {
            event.getToolTip().add(new StringTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)"chineseworkshop.tip.selectable", (Object[])new Object[]{kbSelect.func_197978_k()})));
        }
    }
}

