/*
 * Decompiled with CFR 0.152.
 */
package mods.coffeespawner.block;

import cpw.mods.fml.common.registry.GameRegistry;
import mods.coffeespawner.CoffeeSpawner;
import mods.coffeespawner.tileentity.TileEntityCoffeeMachine;
import mods.coffeespawner.tileentity.TileEntityCoffeeMachinePan;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockCoffeeMachine
extends BlockContainer {
    private boolean is_pan_edition = false;

    public BlockCoffeeMachine(String name, boolean panEdition) {
        super(Material.field_151578_c);
        this.is_pan_edition = panEdition;
        if (this.is_pan_edition) {
            this.func_149676_a(0.19f, 0.0f, 0.19f, 0.81f, 1.0f, 0.81f);
        } else {
            this.func_149676_a(0.19f, 0.0f, 0.19f, 0.81f, 0.95f, 0.81f);
        }
        this.func_149711_c(0.5f);
        this.func_149647_a(CreativeTabs.field_78039_h);
        this.func_149658_d("coffeespawner:particle_" + name);
        this.func_149663_c("coffeespawner." + name);
        GameRegistry.registerBlock((Block)this, (String)name);
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public TileEntity func_149915_a(World world, int i) {
        return this.is_pan_edition ? new TileEntityCoffeeMachinePan() : new TileEntityCoffeeMachine();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int whichDirectionFacing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        world.func_72921_c(x, y, z, whichDirectionFacing, 2);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int arg, float hitX, float hitY, float hitZ) {
        TileEntityCoffeeMachine tile;
        if (!world.field_72995_K && player != null && (tile = this.getTile(world, x, y, z)) != null) {
            if (tile.hasMug()) {
                this.removeMug(world, x, y, z, tile);
                EntityItem item = new EntityItem(world, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, new ItemStack((Item)CoffeeSpawner.coffee));
                world.func_72838_d((Entity)item);
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText("\u00a73Coffee spawns tomorrow."));
            }
        }
        return true;
    }

    public TileEntityCoffeeMachine getTile(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile != null && tile instanceof TileEntityCoffeeMachine ? (TileEntityCoffeeMachine)tile : null;
    }

    public void spawnMug(World world, int x, int y, int z, TileEntityCoffeeMachine tile) {
        if (world == null || tile == null || tile.hasMug()) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockCoffeeMachine) {
            tile.setMug(true);
            tile.func_70296_d();
            world.func_147471_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
    }

    public void removeMug(World world, int x, int y, int z, TileEntityCoffeeMachine tile) {
        if (world == null || tile == null || !tile.hasMug()) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockCoffeeMachine) {
            tile.setMug(false);
            tile.func_70296_d();
            world.func_147471_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
    }
}

