/*
 * Decompiled with CFR 0.152.
 */
package mods.coffeespawner.block;

import com.google.common.base.Predicate;
import mods.coffeespawner.CoffeeSpawner;
import mods.coffeespawner.registry.ItemRegistry;
import mods.coffeespawner.tileentity.TileEntityCoffeeMachine;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCoffeeMachine
extends Block
implements ITileEntityProvider {
    protected static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.19, 0.0, 0.19, 0.81, 0.95, 0.81);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyInteger MODELID = PropertyInteger.func_177719_a((String)"modelid", (int)0, (int)1);

    public BlockCoffeeMachine(String name) {
        super(Material.field_151578_c);
        this.func_149711_c(0.5f);
        this.setRegistryName(name);
        this.func_149663_c("coffeespawner." + name);
        this.func_149647_a(CreativeTabs.field_78039_h);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)MODELID, (Comparable)Integer.valueOf(0)));
    }

    public void initModel() {
        CoffeeSpawner.proxy.registerModel(Item.func_150898_a((Block)this), 0, new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing enumfacing;
        EnumFacing enumFacing = enumfacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        if (meta > 1) {
            meta = 1;
        }
        return this.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)MODELID, (Comparable)Integer.valueOf(meta));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)MODELID, (Comparable)Integer.valueOf((meta & 0xF) >> 2));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return i |= (Integer)state.func_177229_b((IProperty)MODELID) << 2;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MODELID});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityCoffeeMachine tile;
        if (!world.field_72995_K && player != null && (tile = this.getTile(world, pos)) != null) {
            if (tile.hasMug()) {
                this.removeMug(world, pos, tile);
                InventoryHelper.func_180173_a((World)world, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)new ItemStack((Item)ItemRegistry.coffee));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_AQUA + "Coffee spawns tomorrow."));
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCoffeeMachine();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntityCoffeeMachine getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && tile instanceof TileEntityCoffeeMachine ? (TileEntityCoffeeMachine)tile : null;
    }

    public void spawnMug(World world, BlockPos pos, TileEntityCoffeeMachine tile) {
        if (world == null || pos == null || tile == null || tile.hasMug()) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state != null && state.func_177230_c() instanceof BlockCoffeeMachine) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)MODELID, (Comparable)Integer.valueOf(1)));
            tile.setMug(true);
            tile.func_70296_d();
        }
    }

    public void removeMug(World world, BlockPos pos, TileEntityCoffeeMachine tile) {
        if (world == null || pos == null || tile == null || !tile.hasMug()) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state != null && state.func_177230_c() instanceof BlockCoffeeMachine) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)MODELID, (Comparable)Integer.valueOf(0)));
            tile.setMug(false);
            tile.func_70296_d();
        }
    }
}

