/*
 * Decompiled with CFR 0.152.
 */
package mods.coffeespawner.block;

import mods.coffeespawner.CoffeeSpawner;
import mods.coffeespawner.tileentity.TileEntityCoffeeMachine;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockCoffeeMachine
extends Block {
    private static final VoxelShape BOUNDING_BOX_NORMAL = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private static final VoxelShape BOUNDING_BOX_PAN = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)17.0, (double)13.0);
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final IntegerProperty MODELID = IntegerProperty.func_177719_a((String)"modelid", (int)0, (int)1);
    private final boolean isPanModel;

    public BlockCoffeeMachine(String name, boolean isPanModel) {
        super(Block.Properties.func_200945_a((Material)Material.field_151578_c).func_200948_a(0.5f, 5.0f));
        this.isPanModel = isPanModel;
        this.setRegistryName(name);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)MODELID, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, MODELID});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        TileEntityCoffeeMachine tile;
        if (!world.field_72995_K && player != null && (tile = this.getTile(world, pos)) != null) {
            if (tile.hasMug()) {
                this.removeMug(world, pos, tile);
                InventoryHelper.func_180173_a((World)world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)new ItemStack((IItemProvider)CoffeeSpawner.coffee));
            } else {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + "Coffee spawns tomorrow."));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityCoffeeMachine();
    }

    public TileEntityCoffeeMachine getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityCoffeeMachine ? (TileEntityCoffeeMachine)tile : null;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selection) {
        return BOUNDING_BOX_NORMAL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selection) {
        return this.isPanModel ? BOUNDING_BOX_PAN : BOUNDING_BOX_NORMAL;
    }

    public void spawnMug(World world, BlockPos pos, TileEntityCoffeeMachine tile) {
        if (world == null || pos == null || tile == null || tile.hasMug()) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state != null && state.func_177230_c() instanceof BlockCoffeeMachine) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)MODELID, (Comparable)Integer.valueOf(1)));
            tile.setMug(true);
            tile.func_70296_d();
        }
    }

    public void removeMug(World world, BlockPos pos, TileEntityCoffeeMachine tile) {
        if (world == null || pos == null || tile == null || !tile.hasMug()) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state != null && state.func_177230_c() instanceof BlockCoffeeMachine) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)MODELID, (Comparable)Integer.valueOf(0)));
            tile.setMug(false);
            tile.func_70296_d();
        }
    }
}

