/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.dataserializers.DataSerializerItemList;
import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.item.ItemUtils;
import de.maxhenkel.corpse.corelib.net.NetUtils;
import de.maxhenkel.corpse.entities.CorpseBoundingBoxBase;
import de.maxhenkel.corpse.gui.Guis;
import de.maxhenkel.corpse.net.MessageSpawnDeathParticles;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class CorpseEntity
extends CorpseBoundingBoxBase {
    private static final DataParameter<Optional<UUID>> ID = EntityDataManager.func_187226_a(CorpseEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(CorpseEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> SKELETON = EntityDataManager.func_187226_a(CorpseEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> MODEL = EntityDataManager.func_187226_a(CorpseEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<NonNullList<ItemStack>> EQUIPMENT = EntityDataManager.func_187226_a(CorpseEntity.class, DataSerializerItemList.ITEM_LIST);
    private int age;
    private int emptyAge;
    protected Death death;

    public CorpseEntity(EntityType type, World world) {
        super(type, world);
        this.field_70156_m = true;
        this.emptyAge = -1;
        this.death = new Death.Builder(new UUID(0L, 0L), new UUID(0L, 0L)).build();
    }

    public CorpseEntity(World world) {
        this((EntityType)Main.CORPSE_ENTITY_TYPE, world);
    }

    public static CorpseEntity createFromDeath(PlayerEntity player, Death death) {
        CorpseEntity corpse = new CorpseEntity(player.field_70170_p);
        corpse.death = death;
        corpse.setCorpseUUID(death.getPlayerUUID());
        corpse.setCorpseName(death.getPlayerName());
        corpse.setEquipment(death.getEquipment());
        corpse.func_70107_b(death.getPosX(), Math.max(death.getPosY(), 0.0), death.getPosZ());
        corpse.field_70177_z = player.field_70177_z;
        corpse.setCorpseModel(death.getModel());
        return corpse;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.35f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.age;
        this.setIsSkeleton(this.age >= (Integer)Main.SERVER_CONFIG.corpseSkeletonTime.get());
        if (!this.func_189652_ae()) {
            double yMotion = 0.0;
            Vector3d motion = this.func_213322_ci();
            if (this.func_208600_a((ITag)FluidTags.field_206959_a) || this.func_208600_a((ITag)FluidTags.field_206960_b)) {
                yMotion = motion.field_72448_b < 0.0 ? motion.field_72448_b + (motion.field_72448_b < 0.03 ? 0.01 : 0.0) : motion.field_72448_b + (motion.field_72448_b < 0.03 ? 5.0E-4 : 0.0);
            } else if (((Boolean)Main.SERVER_CONFIG.fallIntoVoid.get()).booleanValue() || this.func_226278_cu_() > 0.0) {
                yMotion = Math.max(-2.0, motion.field_72448_b - 0.0625);
            }
            this.func_213293_j(this.func_213322_ci().field_72450_a * 0.75, yMotion, this.func_213322_ci().field_72449_c * 0.75);
            if (!((Boolean)Main.SERVER_CONFIG.fallIntoVoid.get()).booleanValue() && this.func_226278_cu_() < 0.0) {
                this.func_70634_a(this.func_226277_ct_(), 0.0, this.func_226281_cx_());
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if ((Integer)Main.SERVER_CONFIG.corpseForceDespawnTime.get() > 0 && this.age > (Integer)Main.SERVER_CONFIG.corpseForceDespawnTime.get()) {
            this.func_70106_y();
            return;
        }
        boolean empty = this.isEmpty();
        if (empty && this.emptyAge < 0) {
            this.emptyAge = this.age;
        } else if (empty && this.age - this.emptyAge >= (Integer)Main.SERVER_CONFIG.corpseDespawnTime.get()) {
            this.func_70106_y();
        }
    }

    public boolean isMainInventoryEmpty() {
        return this.death.getMainInventory().stream().allMatch(ItemStack::func_190926_b) && this.death.getArmorInventory().stream().allMatch(ItemStack::func_190926_b) && this.death.getOffHandInventory().stream().allMatch(ItemStack::func_190926_b);
    }

    public boolean isAdditionalInventoryEmpty() {
        return this.death.getAdditionalItems().stream().allMatch(ItemStack::func_190926_b);
    }

    public boolean isEmpty() {
        return this.isMainInventoryEmpty() && this.isAdditionalInventoryEmpty();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (((Boolean)Main.SERVER_CONFIG.lavaDamage.get()).booleanValue() && source.func_76347_k() && amount >= 2.0f) {
            this.func_70106_y();
        }
        return super.func_70097_a(source, amount);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            if (((Boolean)Main.SERVER_CONFIG.onlyOwnerAccess.get()).booleanValue()) {
                boolean isOp = playerMP.func_211513_k(playerMP.field_71133_b.func_110455_j());
                if (isOp || !this.getCorpseUUID().isPresent() || playerMP.func_110124_au().equals(this.getCorpseUUID().get())) {
                    Guis.openCorpseGUI((ServerPlayerEntity)player, this);
                } else if (((Boolean)Main.SERVER_CONFIG.skeletonAccess.get()).booleanValue() && this.isSkeleton()) {
                    Guis.openCorpseGUI((ServerPlayerEntity)player, this);
                }
            } else {
                Guis.openCorpseGUI((ServerPlayerEntity)player, this);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ITextComponent func_145748_c_() {
        String name = this.getCorpseName();
        if (name == null || name.trim().isEmpty()) {
            return super.func_145748_c_();
        }
        return new TranslationTextComponent("entity.corpse.corpse_of", new Object[]{this.getCorpseName()});
    }

    public boolean func_90999_ad() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public Optional<UUID> getCorpseUUID() {
        return (Optional)this.field_70180_af.func_187225_a(ID);
    }

    public void setCorpseUUID(UUID uuid) {
        if (uuid == null) {
            this.field_70180_af.func_187227_b(ID, Optional.empty());
        } else {
            this.field_70180_af.func_187227_b(ID, Optional.of(uuid));
        }
    }

    public Death getDeath() {
        return this.death;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDeath(Death death) {
        this.death = death;
    }

    public String getCorpseName() {
        return (String)this.field_70180_af.func_187225_a(NAME);
    }

    public void setCorpseName(String name) {
        this.field_70180_af.func_187227_b(NAME, (Object)name);
    }

    public boolean isSkeleton() {
        return (Boolean)this.field_70180_af.func_187225_a(SKELETON);
    }

    public void setIsSkeleton(boolean skeleton) {
        this.field_70180_af.func_187227_b(SKELETON, (Object)skeleton);
    }

    public byte getCorpseModel() {
        return (Byte)this.field_70180_af.func_187225_a(MODEL);
    }

    public void setCorpseModel(byte model) {
        this.field_70180_af.func_187227_b(MODEL, (Object)model);
    }

    public void setEquipment(NonNullList<ItemStack> equipment) {
        this.field_70180_af.func_187227_b(EQUIPMENT, equipment);
    }

    public NonNullList<ItemStack> getEquipment() {
        return (NonNullList)this.field_70180_af.func_187225_a(EQUIPMENT);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ID, Optional.empty());
        this.field_70180_af.func_187214_a(NAME, (Object)"");
        this.field_70180_af.func_187214_a(SKELETON, (Object)false);
        this.field_70180_af.func_187214_a(MODEL, (Object)0);
        this.field_70180_af.func_187214_a(EQUIPMENT, (Object)NonNullList.func_191197_a((int)EquipmentSlotType.values().length, (Object)ItemStack.field_190927_a));
    }

    public void func_70106_y() {
        for (ItemStack item : this.death.getAllItems()) {
            InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)item);
        }
        super.func_70106_y();
        if (this.field_70170_p instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
            serverWorld.func_217490_a(player -> player.func_70092_e(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()) <= 4096.0).forEach(playerEntity -> NetUtils.sendTo(Main.SIMPLE_CHANNEL, playerEntity, new MessageSpawnDeathParticles(this.func_110124_au())));
        }
    }

    public void spawnDeathParticles() {
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        Vector3d lookVec = this.func_70040_Z().func_72432_b();
        for (int i = 0; i <= 10; ++i) {
            double d = ((double)i / 10.0 - 0.5) * 2.0;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, x + lookVec.field_72450_a * d + (this.field_70170_p.field_73012_v.nextDouble() - 0.5), y + 0.25, z + lookVec.field_72449_c * d + (this.field_70170_p.field_73012_v.nextDouble() - 0.5), 0.0, 0.0, 0.0);
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("Death")) {
            this.death = Death.fromNBT(compound.func_74775_l("Death"));
        } else {
            UUID playerUUID = new UUID(compound.func_74763_f("IDMost"), compound.func_74763_f("IDLeast"));
            UUID deathID = new UUID(compound.func_74763_f("DeathIDMost"), compound.func_74763_f("DeathIDLeast"));
            Death.Builder builder = new Death.Builder(playerUUID, deathID);
            int size = compound.func_74762_e("InventorySize");
            NonNullList additionalItems = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
            ItemUtils.readInventory(compound, "Inventory", (NonNullList<ItemStack>)additionalItems);
            builder.additionalItems((NonNullList<ItemStack>)additionalItems);
            NonNullList equipment = NonNullList.func_191197_a((int)EquipmentSlotType.values().length, (Object)ItemStack.field_190927_a);
            ItemUtils.readItemList(compound, "Equipment", (NonNullList<ItemStack>)equipment);
            builder.equipment((NonNullList<ItemStack>)equipment);
            builder.playerName(compound.func_74779_i("Name"));
            this.death = builder.build();
        }
        this.setEquipment(this.death.getEquipment());
        this.setCorpseUUID(this.death.getPlayerUUID());
        this.setCorpseName(this.death.getPlayerName());
        this.age = compound.func_74762_e("Age");
        if (compound.func_74764_b("EmptyAge")) {
            this.emptyAge = compound.func_74762_e("EmptyAge");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("Death", (INBT)this.death.toNBT());
        compound.func_74768_a("Age", this.age);
        if (this.emptyAge >= 0) {
            compound.func_74768_a("EmptyAge", this.emptyAge);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

