/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair specPairServer = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPairServer.getRight();
        SERVER = (ServerConfig)specPairServer.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (ClientConfig)specPairClient.getLeft();
    }

    public static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class ServerConfig {
        public ForgeConfigSpec.BooleanValue onlyOwnerAccess;
        public ForgeConfigSpec.IntValue corpseDespawnTime;
        public ForgeConfigSpec.IntValue corpseSkeletonTime;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            this.onlyOwnerAccess = builder.comment("If only the owner of the corpse can access the inventory").translation("only_owner_access").define("only_owner_access", false);
            this.corpseDespawnTime = builder.comment("The time passed after a corpse despawns (only if empty)").translation("corpse_despawn_time").defineInRange("corpse_despawn_time", 600, 20, Integer.MAX_VALUE);
            this.corpseSkeletonTime = builder.comment("The time passed after a corpse turns into a skeleton").translation("corpse_skeleton_time").defineInRange("corpse_skeleton_time", 72000, 0, Integer.MAX_VALUE);
        }
    }
}

