/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.corpse.Config;
import de.maxhenkel.corpse.commands.HistoryCommand;
import de.maxhenkel.corpse.entities.EntityCorpse;
import de.maxhenkel.corpse.entities.RenderCorpse;
import de.maxhenkel.corpse.events.DeathEvents;
import de.maxhenkel.corpse.events.KeyEvents;
import de.maxhenkel.corpse.gui.GUIManager;
import de.maxhenkel.corpse.net.MessageOpenHistory;
import de.maxhenkel.corpse.net.MessageRequestDeathHistory;
import de.maxhenkel.corpse.net.MessageShowCorpseInventory;
import de.maxhenkel.corpse.net.MessageSwitchInventoryPage;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

@Mod(value="corpse")
@Mod.EventBusSubscriber
public class Main {
    public static final String MODID = "corpse";
    private static Main instance;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_DEATH_HISTORY;
    public static SimpleChannel SIMPLE_CHANNEL;
    public static final EntityType<EntityCorpse> CORPSE_ENTITY_TYPE;

    public Main() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DeathEvents());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverLoad);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
        SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "default"), () -> "1.0.0", s -> true, s -> true);
        SIMPLE_CHANNEL.registerMessage(0, MessageSwitchInventoryPage.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageSwitchInventoryPage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(1, MessageOpenHistory.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageOpenHistory().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(2, MessageShowCorpseInventory.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageShowCorpseInventory().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(3, MessageRequestDeathHistory.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageRequestDeathHistory().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
    }

    @SubscribeEvent
    public void serverLoad(FMLServerStartingEvent event) {
        HistoryCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCorpse.class, manager -> new RenderCorpse(manager));
        GUIManager.clientSetup();
        KEY_DEATH_HISTORY = new KeyBinding("key.death_history", 85, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_DEATH_HISTORY);
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
    }

    public static Main instance() {
        return instance;
    }

    static {
        CORPSE_ENTITY_TYPE = EntityType.func_200712_a((String)"corpse:corpse", (EntityType.Builder)EntityType.Builder.func_201757_a(EntityCorpse.class, EntityCorpse::new).tracker(128, 1, true));
    }
}

