/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import de.maxhenkel.corpse.Config;
import de.maxhenkel.corpse.PlayerSkins;
import de.maxhenkel.corpse.entities.EntityCorpse;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.model.ModelPlayer;
import net.minecraft.client.renderer.entity.model.ModelSkeleton;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class RenderCorpse
extends Render<EntityCorpse> {
    private static final ResourceLocation SKELETON_TEXTURE = new ResourceLocation("textures/entity/skeleton/skeleton.png");
    private Minecraft mc = Minecraft.func_71410_x();
    private ModelPlayer modelPlayer = new ModelPlayer(0.0f, false);
    private ModelPlayer modelPlayerSlim = new ModelPlayer(0.0f, true);
    private ModelSkeleton modelSkeleton = new ModelSkeleton(){

        public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        }
    };

    public RenderCorpse(RenderManager renderManager) {
        super(renderManager);
        this.modelPlayer.field_78091_s = false;
        this.modelPlayerSlim.field_78091_s = false;
        this.modelSkeleton.field_78091_s = false;
    }

    public void doRender(EntityCorpse entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(360.0f - entity.getCorpseRotation()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)-0.125);
        if (entity.getCorpseAge() >= (Integer)Config.SERVER.corpseSkeletonTime.get()) {
            this.func_110776_a(SKELETON_TEXTURE);
            this.modelSkeleton.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else {
            this.func_110776_a(this.getEntityTexture(entity));
            if (this.isSlim(entity.getCorpseUUID())) {
                this.modelPlayerSlim.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            } else {
                this.modelPlayer.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            }
        }
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityCorpse entity) {
        return PlayerSkins.getSkin(entity.getCorpseUUID(), entity.getCorpseName());
    }

    public boolean isSlim(UUID uuid) {
        NetworkPlayerInfo networkplayerinfo = this.mc.func_147114_u().func_175102_a(uuid);
        return networkplayerinfo == null ? (uuid.hashCode() & 1) == 1 : networkplayerinfo.func_178851_f().equals("slim");
    }
}

