/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.mojang.authlib.GameProfile;
import de.maxhenkel.corpse.Death;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.gui.ContainerDeathHistory;
import de.maxhenkel.corpse.gui.GUIBase;
import de.maxhenkel.corpse.net.MessageShowCorpseInventory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;

public class GUIDeathHistory
extends GUIBase {
    private static final ResourceLocation DEATH_HISTORY_GUI_TEXTURE = new ResourceLocation("corpse", "textures/gui/gui_death_history.png");
    private GuiButton previous;
    private GuiButton next;
    private List<Death> deaths;
    private int index;
    private SimpleDateFormat dateFormat;
    private int hSplit;

    public GUIDeathHistory(List<Death> deaths) {
        super(DEATH_HISTORY_GUI_TEXTURE, new ContainerDeathHistory());
        this.deaths = deaths;
        this.dateFormat = new SimpleDateFormat(new TextComponentTranslation("gui.death_history.date_format", new Object[0]).func_150261_e());
        this.index = 0;
        this.field_146999_f = 248;
        this.field_147000_g = 166;
        this.hSplit = this.field_146999_f / 2;
    }

    protected void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int padding = 7;
        int buttonWidth = 50;
        int buttonHeight = 20;
        this.previous = this.func_189646_b(new GuiButton(0, this.field_147003_i + padding, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, new TextComponentTranslation("button.previous", new Object[0]).func_150254_d()){

            public void func_194829_a(double x, double y) {
                super.func_194829_a(x, y);
                GUIDeathHistory.this.index--;
                if (GUIDeathHistory.this.index < 0) {
                    GUIDeathHistory.this.index = 0;
                }
            }
        });
        this.func_189646_b(new GuiButton(2, this.field_147003_i + (this.field_146999_f - buttonWidth) / 2, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, new TextComponentTranslation("button.show_items", new Object[0]).func_150254_d()){

            public void func_194829_a(double x, double y) {
                super.func_194829_a(x, y);
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageShowCorpseInventory(GUIDeathHistory.this.getCurrentDeath().getPlayerUUID(), GUIDeathHistory.this.getCurrentDeath().getId()));
            }
        });
        this.next = this.func_189646_b(new GuiButton(1, this.field_147003_i + this.field_146999_f - buttonWidth - padding, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, new TextComponentTranslation("button.next", new Object[0]).func_150254_d()){

            public void func_194829_a(double x, double y) {
                super.func_194829_a(x, y);
                GUIDeathHistory.this.index++;
                if (GUIDeathHistory.this.index >= GUIDeathHistory.this.deaths.size()) {
                    GUIDeathHistory.this.index = GUIDeathHistory.this.deaths.size() - 1;
                }
            }
        });
    }

    public boolean mouseClicked(double x, double y, int clickType) {
        if (x >= (double)(this.field_147003_i + 7) && x <= (double)(this.field_147003_i + this.hSplit) && y >= (double)(this.field_147009_r + 70) && y <= (double)(this.field_147009_r + 100 + this.field_146289_q.field_78288_b)) {
            BlockPos pos = this.getCurrentDeath().getBlockPos();
            ITextComponent teleport = TextComponentUtils.func_197676_a((ITextComponent)new TextComponentTranslation("chat.coordinates", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()})).func_211710_a(style -> style.func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/execute in " + this.getCurrentDeath().getDimension() + " run tp @s " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("chat.coordinates.tooltip", new Object[0]))));
            this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("chat.teleport_death_location", new Object[]{teleport}));
            this.field_146297_k.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.field_146297_k.func_147108_a(null);
        }
        return super.mouseClicked(x, y, clickType);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        Death death = this.getCurrentDeath();
        String title = new TextComponentTranslation("gui.death_history.title", new Object[0]).func_150254_d();
        int titleWidth = this.field_146289_q.func_78256_a(title);
        this.field_146289_q.func_211126_b(TextFormatting.BLACK + title, (float)(this.field_147003_i + (this.field_146999_f - titleWidth) / 2), (float)(this.field_147009_r + 7), 0);
        String date = this.dateFormat.format(new Date(death.getTimestamp()));
        int dateWidth = this.field_146289_q.func_78256_a(date);
        this.field_146289_q.func_211126_b(TextFormatting.DARK_GRAY + date, (float)(this.field_147003_i + (this.field_146999_f - dateWidth) / 2), (float)(this.field_147009_r + 20), 0);
        String textName = new TextComponentTranslation("gui.death_history.name", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.DARK_GRAY + textName, this.field_147009_r + 40);
        String name = death.getPlayerName();
        this.drawRight(TextFormatting.GRAY + name, this.field_147009_r + 40);
        String textDimension = new TextComponentTranslation("gui.death_history.dimension", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.DARK_GRAY + textDimension, this.field_147009_r + 55);
        String dimension = death.getDimension().split(":")[1];
        this.drawRight(TextFormatting.GRAY + dimension, this.field_147009_r + 55);
        String textLocation = new TextComponentTranslation("gui.death_history.location", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.DARK_GRAY + textLocation, this.field_147009_r + 70);
        this.drawRight(TextFormatting.GRAY + "" + Math.round(death.getPosX()) + " X", this.field_147009_r + 70);
        this.drawRight(TextFormatting.GRAY + "" + Math.round(death.getPosY()) + " Y", this.field_147009_r + 85);
        this.drawRight(TextFormatting.GRAY + "" + Math.round(death.getPosZ()) + " Z", this.field_147009_r + 100);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EntityOtherPlayerMP player = new EntityOtherPlayerMP((World)this.field_146297_k.field_71441_e, new GameProfile(death.getPlayerUUID(), death.getPlayerName()));
        player.field_70131_O = Float.MAX_VALUE;
        GuiInventory.func_147046_a((int)(this.field_147003_i + this.field_146999_f - (this.field_146999_f - this.hSplit) / 2), (int)(this.field_147009_r + this.field_147000_g / 2 + 30), (int)40, (float)(this.field_147003_i + this.field_146999_f - (this.field_146999_f - this.hSplit) / 2 - mouseX), (float)(this.field_147009_r + this.field_147000_g / 2 - mouseY), (EntityLivingBase)player);
        if (mouseX >= this.field_147003_i + 7 && mouseX <= this.field_147003_i + this.hSplit && mouseY >= this.field_147009_r + 70 && mouseY <= this.field_147009_r + 100 + this.field_146289_q.field_78288_b) {
            this.func_146279_a(new TextComponentTranslation("tooltip.teleport", new Object[0]).func_150254_d(), mouseX, mouseY);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.previous.field_146124_l = this.index > 0;
        this.next.field_146124_l = this.index < this.deaths.size() - 1;
    }

    public void drawLeft(String string, int height) {
        int offset = 7;
        int offsetLeft = this.field_147003_i + offset;
        this.field_146289_q.func_211126_b(string, (float)offsetLeft, (float)height, 0);
    }

    public void drawRight(String string, int height) {
        int strWidth = this.field_146289_q.func_78256_a(string);
        this.field_146289_q.func_211126_b(string, (float)(this.field_147003_i + this.hSplit - strWidth), (float)height, 0);
    }

    public Death getCurrentDeath() {
        return this.deaths.get(this.index);
    }
}

