/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.Death;
import de.maxhenkel.corpse.DeathManager;
import de.maxhenkel.corpse.entities.EntityCorpse;
import de.maxhenkel.corpse.gui.GUICorpse;
import de.maxhenkel.corpse.gui.GUIRegistry;
import de.maxhenkel.corpse.gui.InteractionObjectCorpse;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class GUIManager {
    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup() {
        GUIRegistry.register(new ResourceLocation("corpse", "corpse"), openContainer -> {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            PacketBuffer buffer = openContainer.getAdditionalData();
            boolean isHistory = buffer.readBoolean();
            if (isHistory) {
                Death death = Death.fromNBT(buffer.func_150793_b());
                return new GUICorpse((IInventory)player.field_71071_by, EntityCorpse.createFromDeath((EntityPlayer)player, death), player.field_71075_bZ.field_75098_d);
            }
            UUID uuid = new UUID(buffer.readLong(), buffer.readLong());
            EntityCorpse entity = (EntityCorpse)((Object)((Object)player.field_70170_p.func_175644_a(EntityCorpse.class, corpse -> corpse.func_110124_au().equals(uuid)).stream().findFirst().get()));
            return new GUICorpse((IInventory)player.field_71071_by, entity, true);
        });
    }

    public static void openCorpseGUI(EntityPlayerMP player, EntityCorpse corpse) {
        NetworkHooks.openGui((EntityPlayerMP)player, (IInteractionObject)new InteractionObjectCorpse(corpse, true), packetBuffer -> {
            packetBuffer.writeBoolean(false);
            packetBuffer.writeLong(corpse.func_110124_au().getMostSignificantBits());
            packetBuffer.writeLong(corpse.func_110124_au().getLeastSignificantBits());
        });
    }

    public static void openCorpseGUI(EntityPlayerMP playerToShow, EntityPlayerMP player, UUID uuid) {
        Death death = DeathManager.getDeath(player, uuid);
        if (death == null) {
            return;
        }
        EntityCorpse corpse = EntityCorpse.createFromDeath((EntityPlayer)playerToShow, death);
        NetworkHooks.openGui((EntityPlayerMP)playerToShow, (IInteractionObject)new InteractionObjectCorpse(corpse, playerToShow.field_71075_bZ.field_75098_d), packetBuffer -> {
            packetBuffer.writeBoolean(true);
            packetBuffer.func_150786_a(death.toNBT());
        });
    }
}

