/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse;

import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;

public class Death {
    private UUID id;
    private UUID playerUUID;
    private String playerName;
    private NonNullList<ItemStack> items;
    private long timestamp;
    private int experience;
    private double posX;
    private double posY;
    private double posZ;
    private String dimension;

    private Death() {
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getExperience() {
        return this.experience;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public String getDimension() {
        return this.dimension;
    }

    public DimensionType getDimensionType() {
        return DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(this.dimension));
    }

    public String toString() {
        return "Death{name=" + this.playerName + "timestamp=" + this.timestamp + "}";
    }

    public static Death fromPlayer(PlayerEntity player, NonNullList<ItemStack> items) {
        Death death = new Death();
        death.id = UUID.randomUUID();
        death.playerUUID = player.func_110124_au();
        death.playerName = player.func_200200_C_().func_150261_e();
        death.items = items;
        death.timestamp = System.currentTimeMillis();
        death.experience = player.field_71068_ca;
        death.posX = player.field_70165_t;
        death.posY = player.field_70163_u;
        death.posZ = player.field_70161_v;
        death.dimension = DimensionType.func_212678_a((DimensionType)player.field_71093_bK).toString();
        return death;
    }

    public static Death fromNBT(CompoundNBT compound) {
        Death death = new Death();
        death.id = new UUID(compound.func_74763_f("IdMost"), compound.func_74763_f("IdLeast"));
        death.playerUUID = new UUID(compound.func_74763_f("PlayerUuidMost"), compound.func_74763_f("PlayerUuidLeast"));
        death.playerName = compound.func_74779_i("PlayerName");
        death.items = NonNullList.func_191196_a();
        if (compound.func_74764_b("Items")) {
            ListNBT itemList = compound.func_150295_c("Items", 10);
            for (int i = 0; i < itemList.size(); ++i) {
                death.items.add((Object)ItemStack.func_199557_a((CompoundNBT)itemList.func_150305_b(i)));
            }
        }
        death.timestamp = compound.func_74763_f("Timestamp");
        death.experience = compound.func_74762_e("Experience");
        death.posX = compound.func_74769_h("PosX");
        death.posY = compound.func_74769_h("PosY");
        death.posZ = compound.func_74769_h("PosZ");
        death.dimension = compound.func_74779_i("Dimension");
        return death;
    }

    public CompoundNBT toNBT() {
        return this.toNBT(true);
    }

    public CompoundNBT toNBT(boolean withItems) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74772_a("IdMost", this.id.getMostSignificantBits());
        compound.func_74772_a("IdLeast", this.id.getLeastSignificantBits());
        compound.func_74772_a("PlayerUuidMost", this.playerUUID.getMostSignificantBits());
        compound.func_74772_a("PlayerUuidLeast", this.playerUUID.getLeastSignificantBits());
        compound.func_74778_a("PlayerName", this.playerName);
        if (withItems) {
            ListNBT itemList = new ListNBT();
            for (ItemStack stack : this.items) {
                itemList.add((Object)stack.func_77955_b(new CompoundNBT()));
            }
            compound.func_218657_a("Items", (INBT)itemList);
        }
        compound.func_74772_a("Timestamp", this.timestamp);
        compound.func_74768_a("Experience", this.experience);
        compound.func_74780_a("PosX", this.posX);
        compound.func_74780_a("PosY", this.posY);
        compound.func_74780_a("PosZ", this.posZ);
        compound.func_74778_a("Dimension", this.dimension);
        return compound;
    }
}

