/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse;

import de.maxhenkel.corpse.Death;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.world.server.ServerWorld;

public class DeathManager {
    public static void addDeath(ServerPlayerEntity player, Death death) {
        try {
            File deathFile = DeathManager.getDeathFile(player, death.getId());
            deathFile.getParentFile().mkdirs();
            CompressedStreamTools.func_74795_b((CompoundNBT)death.toNBT(), (File)deathFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static Death getDeath(ServerPlayerEntity player, UUID id) {
        try {
            return Death.fromNBT(CompressedStreamTools.func_74797_a((File)DeathManager.getDeathFile(player, id)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Death> getDeaths(ServerPlayerEntity player) {
        return DeathManager.getDeaths(player);
    }

    public static List<Death> getDeaths(ServerPlayerEntity context, ServerPlayerEntity player) {
        return DeathManager.getDeaths(context, player);
    }

    public static List<Death> getDeaths(ServerPlayerEntity context, UUID playerUUID) {
        File playerDeathFolder = DeathManager.getPlayerDeathFolder(context, playerUUID);
        if (!playerDeathFolder.exists()) {
            return Collections.emptyList();
        }
        File[] deaths = playerDeathFolder.listFiles((dir, name) -> {
            String[] split = name.split("\\.");
            if (split.length != 2) {
                return false;
            }
            if (split[1].equals("dat")) {
                try {
                    UUID.fromString(split[0]);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        });
        return Arrays.stream(deaths).map(f -> {
            try {
                return Death.fromNBT(CompressedStreamTools.func_74797_a((File)f));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).filter(d -> d != null).sorted(Comparator.comparingLong(Death::getTimestamp).reversed()).collect(Collectors.toList());
    }

    public static File getDeathFile(ServerPlayerEntity player, UUID id) {
        return new File(DeathManager.getPlayerDeathFolder(player), id.toString() + ".dat");
    }

    public static File getPlayerDeathFolder(ServerPlayerEntity player) {
        return DeathManager.getPlayerDeathFolder(player, player.func_110124_au());
    }

    public static File getPlayerDeathFolder(ServerPlayerEntity context, UUID uuid) {
        return new File(DeathManager.getDeathFolder(context.func_71121_q()), uuid.toString());
    }

    public static File getDeathFolder(ServerWorld world) {
        return new File(world.func_217485_w().func_75765_b(), "deaths");
    }
}

