/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.corpse.Config;
import de.maxhenkel.corpse.PlayerSkins;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.entities.FakeMobEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.SkeletonModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class CorpseRenderer
extends EntityRenderer<CorpseEntity> {
    private static final ResourceLocation SKELETON_TEXTURE = new ResourceLocation("textures/entity/skeleton/skeleton.png");
    private Minecraft mc = Minecraft.func_71410_x();
    private PlayerModel modelPlayer = new PlayerModel(0.0f, false);
    private PlayerModel modelPlayerSlim = new PlayerModel(0.0f, true);
    private SkeletonModel modelSkeleton = new SkeletonModel(){

        public void func_212844_a_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        }
    };
    private FakeMobEntity fakeLivingEntity = new FakeMobEntity();

    public CorpseRenderer(EntityRendererManager renderManager) {
        super(renderManager);
        this.modelPlayer.field_217114_e = false;
        this.modelPlayerSlim.field_217114_e = false;
        this.modelSkeleton.field_217114_e = false;
    }

    public void doRender(CorpseEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.rotatef((float)(360.0f - entity.getCorpseRotation()), (float)0.0f, (float)1.0f, (float)0.0f);
        if (((Boolean)Config.SERVER.spawnCorpseOnFace.get()).booleanValue()) {
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translated((double)0.0, (double)-0.5, (double)0.125);
        } else {
            GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translated((double)0.0, (double)-0.5, (double)-0.125);
        }
        this.fakeLivingEntity.func_70107_b(x, y, z);
        if (entity.isSkeleton()) {
            this.func_110776_a(SKELETON_TEXTURE);
            this.modelSkeleton.func_78088_a((LivingEntity)this.fakeLivingEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else {
            this.func_110776_a(this.getEntityTexture(entity));
            if (this.isSlim(entity.getCorpseUUID())) {
                this.modelPlayerSlim.func_78088_a((LivingEntity)this.fakeLivingEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            } else {
                this.modelPlayer.func_78088_a((LivingEntity)this.fakeLivingEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            }
        }
        GlStateManager.popMatrix();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(CorpseEntity entity) {
        return PlayerSkins.getSkin(entity.getCorpseUUID(), entity.getCorpseName());
    }

    public boolean isSlim(UUID uuid) {
        NetworkPlayerInfo networkplayerinfo = this.mc.func_147114_u().func_175102_a(uuid);
        return networkplayerinfo == null ? (uuid.hashCode() & 1) == 1 : networkplayerinfo.func_178851_f().equals("slim");
    }
}

