/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.ContainerBase;
import de.maxhenkel.corpse.gui.CorpseSlot;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;

public class CorpseContainer
extends ContainerBase {
    private CorpseEntity corpse;
    private boolean editable;

    public CorpseContainer(int id, IInventory playerInventory, CorpseEntity corpse, boolean editable) {
        super(Main.CONTAINER_TYPE_CORPSE, id, playerInventory, corpse);
        this.corpse = corpse;
        this.editable = editable;
        this.setSlots(0);
    }

    public CorpseContainer(int id, IInventory playerInventory, CorpseEntity corpse) {
        this(id, playerInventory, corpse, false);
    }

    public void setSlots(int start) {
        this.field_75151_b.clear();
        for (int j = 0; j < 6; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new CorpseSlot(this.corpse, start + k + j * 9, 8 + k * 18, 19 + j * 18, this.editable));
            }
        }
        this.addInvSlots();
        this.func_75142_b();
    }

    public CorpseEntity getCorpse() {
        return this.corpse;
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    @Override
    public int getInvOffset() {
        return 82;
    }

    @Override
    public int getInventorySize() {
        return 54;
    }
}

