/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseContainer;
import de.maxhenkel.corpse.gui.ScreenBase;
import de.maxhenkel.corpse.net.MessageSwitchInventoryPage;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CorpseScreen
extends ScreenBase<CorpseContainer> {
    private static final ResourceLocation CORPSE_GUI_TEXTURE = new ResourceLocation("corpse", "textures/gui/gui_corpse.png");
    private PlayerInventory playerInventory;
    private CorpseEntity corpse;
    private Button previous;
    private Button next;
    private int page;

    public CorpseScreen(CorpseEntity corpse, PlayerInventory playerInventory, CorpseContainer container, ITextComponent title) {
        super(CORPSE_GUI_TEXTURE, container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.corpse = corpse;
        this.page = 0;
        this.field_146999_f = 176;
        this.field_147000_g = 248;
    }

    protected void init() {
        super.init();
        this.buttons.clear();
        int left = (this.width - this.field_146999_f) / 2;
        int padding = 7;
        int buttonWidth = 50;
        int buttonHeight = 20;
        this.previous = (Button)this.addButton((Widget)new Button(left + padding, this.field_147009_r + 149 - buttonHeight, buttonWidth, buttonHeight, new TranslationTextComponent("button.previous", new Object[0]).func_150254_d(), button -> {
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            }
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSwitchInventoryPage(this.page));
        }));
        this.next = (Button)this.addButton((Widget)new Button(left + this.field_146999_f - buttonWidth - padding, this.field_147009_r + 149 - buttonHeight, buttonWidth, buttonHeight, new TranslationTextComponent("button.next", new Object[0]).func_150254_d(), button -> {
            ++this.page;
            if (this.page >= this.getPages()) {
                this.page = this.getPages() - 1;
            }
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSwitchInventoryPage(this.page));
        }));
    }

    public void tick() {
        super.tick();
        this.previous.active = this.page > 0;
        this.next.active = this.page < this.getPages() - 1;
    }

    private int getPages() {
        return this.corpse.func_70302_i_() / 54;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.font.func_211126_b(this.corpse.func_145748_c_().func_150254_d(), 7.0f, 7.0f, 0x404040);
        this.font.func_211126_b(this.playerInventory.func_145748_c_().func_150254_d(), 7.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        String pageName = new TranslationTextComponent("gui.corpse.page", new Object[]{this.page + 1, this.getPages()}).func_150254_d();
        int pageWidth = this.font.func_78256_a(pageName);
        this.font.func_211126_b(pageName, (float)(this.field_146999_f / 2 - pageWidth / 2), (float)(this.field_147000_g - 113), 0x404040);
    }
}

