/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.corpse.Death;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.gui.DeathHistoryContainer;
import de.maxhenkel.corpse.gui.ScreenBase;
import de.maxhenkel.corpse.net.MessageShowCorpseInventory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class DeathHistoryScreen
extends ScreenBase {
    private static final ResourceLocation DEATH_HISTORY_GUI_TEXTURE = new ResourceLocation("corpse", "textures/gui/gui_death_history.png");
    private Button previous;
    private Button next;
    private List<Death> deaths;
    private int index;
    private SimpleDateFormat dateFormat;
    private int hSplit;

    public DeathHistoryScreen(List<Death> deaths) {
        super(DEATH_HISTORY_GUI_TEXTURE, new DeathHistoryContainer(), null, (ITextComponent)new TranslationTextComponent("gui.death_history.title", new Object[0]));
        this.deaths = deaths;
        this.dateFormat = new SimpleDateFormat(new TranslationTextComponent("gui.death_history.date_format", new Object[0]).func_150261_e());
        this.index = 0;
        this.field_146999_f = 248;
        this.field_147000_g = 166;
        this.hSplit = this.field_146999_f / 2;
    }

    protected void init() {
        super.init();
        this.buttons.clear();
        int padding = 7;
        int buttonWidth = 50;
        int buttonHeight = 20;
        this.previous = (Button)this.addButton((Widget)new Button(this.field_147003_i + padding, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, new TranslationTextComponent("button.previous", new Object[0]).func_150254_d(), button -> {
            --this.index;
            if (this.index < 0) {
                this.index = 0;
            }
        }));
        this.addButton((Widget)new Button(this.field_147003_i + (this.field_146999_f - buttonWidth) / 2, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, new TranslationTextComponent("button.show_items", new Object[0]).func_150254_d(), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageShowCorpseInventory(this.getCurrentDeath().getPlayerUUID(), this.getCurrentDeath().getId()))));
        this.next = (Button)this.addButton((Widget)new Button(this.field_147003_i + this.field_146999_f - buttonWidth - padding, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, new TranslationTextComponent("button.next", new Object[0]).func_150254_d(), button -> {
            ++this.index;
            if (this.index >= this.deaths.size()) {
                this.index = this.deaths.size() - 1;
            }
        }));
    }

    public boolean mouseClicked(double x, double y, int clickType) {
        if (x >= (double)(this.field_147003_i + 7) && x <= (double)(this.field_147003_i + this.hSplit) && y >= (double)(this.field_147009_r + 70)) {
            this.font.getClass();
            if (y <= (double)(this.field_147009_r + 100 + 9)) {
                BlockPos pos = this.getCurrentDeath().getBlockPos();
                ITextComponent teleport = TextComponentUtils.func_197676_a((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()})).func_211710_a(style -> style.func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/execute in " + this.getCurrentDeath().getDimension() + " run tp @s " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("chat.coordinates.tooltip", new Object[0]))));
                this.minecraft.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("chat.teleport_death_location", new Object[]{teleport}));
                this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.minecraft.func_147108_a(null);
            }
        }
        return super.mouseClicked(x, y, clickType);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        Death death = this.getCurrentDeath();
        String title = new TranslationTextComponent("gui.death_history.title", new Object[0]).func_150254_d();
        int titleWidth = this.font.func_78256_a(title);
        this.font.func_211126_b(TextFormatting.BLACK + title, (float)(this.field_147003_i + (this.field_146999_f - titleWidth) / 2), (float)(this.field_147009_r + 7), 0);
        String date = this.dateFormat.format(new Date(death.getTimestamp()));
        int dateWidth = this.font.func_78256_a(date);
        this.font.func_211126_b(TextFormatting.DARK_GRAY + date, (float)(this.field_147003_i + (this.field_146999_f - dateWidth) / 2), (float)(this.field_147009_r + 20), 0);
        String textName = new TranslationTextComponent("gui.death_history.name", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.DARK_GRAY + textName, this.field_147009_r + 40);
        String name = death.getPlayerName();
        this.drawRight(TextFormatting.GRAY + name, this.field_147009_r + 40);
        String textDimension = new TranslationTextComponent("gui.death_history.dimension", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.DARK_GRAY + textDimension, this.field_147009_r + 55);
        String dimension = death.getDimension().split(":")[1];
        this.drawRight(TextFormatting.GRAY + dimension, this.field_147009_r + 55);
        String textLocation = new TranslationTextComponent("gui.death_history.location", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.DARK_GRAY + textLocation, this.field_147009_r + 70);
        this.drawRight(TextFormatting.GRAY + "" + Math.round(death.getPosX()) + " X", this.field_147009_r + 70);
        this.drawRight(TextFormatting.GRAY + "" + Math.round(death.getPosY()) + " Y", this.field_147009_r + 85);
        this.drawRight(TextFormatting.GRAY + "" + Math.round(death.getPosZ()) + " Z", this.field_147009_r + 100);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RemoteClientPlayerEntity player = new RemoteClientPlayerEntity(this.minecraft.field_71441_e, new GameProfile(death.getPlayerUUID(), death.getPlayerName())){

            public EntitySize func_213305_a(Pose pose) {
                return new EntitySize(super.func_213305_a((Pose)pose).field_220315_a, Float.MAX_VALUE, true);
            }
        };
        player.func_213323_x_();
        InventoryScreen.func_147046_a((int)(this.field_147003_i + this.field_146999_f - (this.field_146999_f - this.hSplit) / 2), (int)(this.field_147009_r + this.field_147000_g / 2 + 30), (int)40, (float)(this.field_147003_i + this.field_146999_f - (this.field_146999_f - this.hSplit) / 2 - mouseX), (float)(this.field_147009_r + this.field_147000_g / 2 - mouseY), (LivingEntity)player);
        if (mouseX >= this.field_147003_i + 7 && mouseX <= this.field_147003_i + this.hSplit && mouseY >= this.field_147009_r + 70) {
            this.font.getClass();
            if (mouseY <= this.field_147009_r + 100 + 9) {
                this.renderTooltip(new TranslationTextComponent("tooltip.teleport", new Object[0]).func_150254_d(), mouseX, mouseY);
            }
        }
    }

    public void tick() {
        super.tick();
        this.previous.active = this.index > 0;
        this.next.active = this.index < this.deaths.size() - 1;
    }

    public void drawLeft(String string, int height) {
        int offset = 7;
        int offsetLeft = this.field_147003_i + offset;
        this.font.func_211126_b(string, (float)offsetLeft, (float)height, 0);
    }

    public void drawRight(String string, int height) {
        int strWidth = this.font.func_78256_a(string);
        this.font.func_211126_b(string, (float)(this.field_147003_i + this.hSplit - strWidth), (float)height, 0);
    }

    public Death getCurrentDeath() {
        return this.deaths.get(this.index);
    }
}

