/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.Death;
import de.maxhenkel.corpse.DeathManager;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseContainer;
import de.maxhenkel.corpse.gui.CorpseContainerProvider;
import de.maxhenkel.corpse.gui.CorpseScreen;
import java.util.UUID;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ScreenManager {
    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup() {
        ScreenManager.IScreenFactory factory = (container, playerInventory, name) -> new CorpseScreen(container.getCorpse(), playerInventory, (CorpseContainer)container, name);
        net.minecraft.client.gui.ScreenManager.func_216911_a((ContainerType)Main.CONTAINER_TYPE_CORPSE, (ScreenManager.IScreenFactory)factory);
    }

    public static void openCorpseGUI(ServerPlayerEntity player, CorpseEntity corpse) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new CorpseContainerProvider(corpse, true, false), packetBuffer -> {
            packetBuffer.writeBoolean(false);
            packetBuffer.writeLong(corpse.func_110124_au().getMostSignificantBits());
            packetBuffer.writeLong(corpse.func_110124_au().getLeastSignificantBits());
        });
    }

    public static void openCorpseGUI(ServerPlayerEntity playerToShow, ServerPlayerEntity player, UUID uuid) {
        Death death = DeathManager.getDeath(player, uuid);
        if (death == null) {
            return;
        }
        CorpseEntity corpse = CorpseEntity.createFromDeath((PlayerEntity)playerToShow, death);
        NetworkHooks.openGui((ServerPlayerEntity)playerToShow, (INamedContainerProvider)new CorpseContainerProvider(corpse, playerToShow.field_71075_bZ.field_75098_d, true), packetBuffer -> {
            packetBuffer.writeBoolean(true);
            packetBuffer.func_150786_a(death.toNBT());
        });
    }
}

