/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.client.PlayerSkins;
import de.maxhenkel.corpse.entities.CorpseEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.SkeletonModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class CorpseRenderer
extends EntityRenderer<CorpseEntity> {
    private static final ResourceLocation SKELETON_TEXTURE = new ResourceLocation("textures/entity/skeleton/skeleton.png");
    private PlayerModel modelPlayer = new PlayerModel(0.0f, false);
    private PlayerModel modelPlayerSlim = new PlayerModel(0.0f, true);
    private SkeletonModel modelSkeleton = new SkeletonModel(){

        public void func_225597_a_(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        }
    };

    public CorpseRenderer(EntityRendererManager renderManager) {
        super(renderManager);
        this.modelPlayer.field_217114_e = false;
        this.modelPlayerSlim.field_217114_e = false;
        this.modelSkeleton.field_217114_e = false;
    }

    public ResourceLocation getEntityTexture(CorpseEntity entity) {
        if (entity.isSkeleton()) {
            return SKELETON_TEXTURE;
        }
        return PlayerSkins.getSkin(entity.getCorpseUUID(), entity.getCorpseName());
    }

    public void render(CorpseEntity entity, float f1, float f2, MatrixStack matrixStack, IRenderTypeBuffer buffer, int i) {
        super.func_225623_a_((Entity)entity, f1, f2, matrixStack, buffer, i);
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(360.0f - entity.getCorpseRotation()));
        if (((Boolean)Main.SERVER_CONFIG.spawnCorpseOnFace.get()).booleanValue()) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            matrixStack.func_227861_a_(0.0, -0.5, 0.125625);
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStack.func_227861_a_(0.0, -0.5, -0.125625);
        }
        if (entity.isSkeleton()) {
            this.modelSkeleton.func_225598_a_(matrixStack, buffer.getBuffer(this.modelSkeleton.func_228282_a_(this.getEntityTexture(entity))), i, 0xFFFFFF, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (PlayerSkins.isSlim(entity.getCorpseUUID())) {
            this.modelPlayerSlim.func_225598_a_(matrixStack, buffer.getBuffer(this.modelPlayerSlim.func_228282_a_(this.getEntityTexture(entity))), i, 0xFFFFFF, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.modelPlayer.func_225598_a_(matrixStack, buffer.getBuffer(this.modelPlayer.func_228282_a_(this.getEntityTexture(entity))), i, 0xFFFFFF, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStack.func_227865_b_();
    }
}

