/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.inventory.ContainerBase;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseSlot;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;

public class CorpseContainer
extends ContainerBase {
    private CorpseEntity corpse;
    private boolean editable;
    private boolean history;

    public CorpseContainer(int id, IInventory playerInventory, CorpseEntity corpse, boolean editable, boolean history) {
        super(Main.CONTAINER_TYPE_CORPSE, id, playerInventory, corpse);
        this.corpse = corpse;
        this.editable = editable;
        this.history = history;
        this.setSlots(0);
    }

    public CorpseContainer(int id, IInventory playerInventory, CorpseEntity corpse) {
        this(id, playerInventory, corpse, false, true);
    }

    public void setSlots(int start) {
        this.field_75151_b.clear();
        for (int j = 0; j < 6; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new CorpseSlot(this.corpse, start + k + j * 9, 8 + k * 18, 19 + j * 18, this.editable));
            }
        }
        this.addPlayerInventorySlots();
        this.func_75142_b();
    }

    public CorpseEntity getCorpse() {
        return this.corpse;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isHistory() {
        return this.history;
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        if (this.history) {
            return true;
        }
        return this.corpse.func_70300_a(player) && this.corpse.func_70032_d((Entity)player) < 8.0f && this.corpse.func_70089_S();
    }

    @Override
    public int getInvOffset() {
        return 82;
    }

    @Override
    public int getInventorySize() {
        return 54;
    }
}

