/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse;

import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public class Death {
    private UUID id;
    private UUID playerUUID;
    private String playerName;
    private NonNullList<ItemStack> items;
    private NonNullList<ItemStack> equipment;
    private long timestamp;
    private int experience;
    private double posX;
    private double posY;
    private double posZ;
    private String dimension;

    private Death() {
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public NonNullList<ItemStack> getEquipment() {
        return this.equipment;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getExperience() {
        return this.experience;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public String getDimension() {
        return this.dimension;
    }

    public String toString() {
        return "Death{name=" + this.playerName + "timestamp=" + this.timestamp + "}";
    }

    public static Death fromPlayer(PlayerEntity player) {
        Death death = new Death();
        death.id = UUID.randomUUID();
        death.playerUUID = player.func_110124_au();
        death.playerName = player.func_200200_C_().func_150261_e();
        death.items = NonNullList.func_191196_a();
        death.equipment = NonNullList.func_191197_a((int)EquipmentSlotType.values().length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < death.equipment.size(); ++i) {
            death.equipment.set(i, (Object)player.func_184582_a(EquipmentSlotType.values()[i]));
        }
        death.timestamp = System.currentTimeMillis();
        death.experience = player.field_71068_ca;
        death.posX = player.func_226277_ct_();
        death.posY = player.func_226278_cu_();
        death.posZ = player.func_226281_cx_();
        death.dimension = player.field_70170_p.func_234923_W_().func_240901_a_().toString();
        return death;
    }

    public void addDrops(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public static Death fromNBT(CompoundNBT compound) {
        int i;
        ListNBT itemList;
        Death death = new Death();
        death.id = new UUID(compound.func_74763_f("IdMost"), compound.func_74763_f("IdLeast"));
        death.playerUUID = new UUID(compound.func_74763_f("PlayerUuidMost"), compound.func_74763_f("PlayerUuidLeast"));
        death.playerName = compound.func_74779_i("PlayerName");
        death.items = NonNullList.func_191196_a();
        if (compound.func_74764_b("Items")) {
            itemList = compound.func_150295_c("Items", 10);
            for (i = 0; i < itemList.size(); ++i) {
                death.items.add((Object)ItemStack.func_199557_a((CompoundNBT)itemList.func_150305_b(i)));
            }
        }
        death.equipment = NonNullList.func_191197_a((int)EquipmentSlotType.values().length, (Object)ItemStack.field_190927_a);
        if (compound.func_74764_b("Equipment")) {
            itemList = compound.func_150295_c("Equipment", 10);
            for (i = 0; i < itemList.size(); ++i) {
                death.equipment.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)itemList.func_150305_b(i)));
            }
        }
        death.timestamp = compound.func_74763_f("Timestamp");
        death.experience = compound.func_74762_e("Experience");
        death.posX = compound.func_74769_h("PosX");
        death.posY = compound.func_74769_h("PosY");
        death.posZ = compound.func_74769_h("PosZ");
        death.dimension = compound.func_74779_i("Dimension");
        return death;
    }

    public CompoundNBT toNBT() {
        return this.toNBT(true);
    }

    public CompoundNBT toNBT(boolean withItems) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74772_a("IdMost", this.id.getMostSignificantBits());
        compound.func_74772_a("IdLeast", this.id.getLeastSignificantBits());
        compound.func_74772_a("PlayerUuidMost", this.playerUUID.getMostSignificantBits());
        compound.func_74772_a("PlayerUuidLeast", this.playerUUID.getLeastSignificantBits());
        compound.func_74778_a("PlayerName", this.playerName);
        if (withItems) {
            ListNBT itemList = new ListNBT();
            for (ItemStack stack : this.items) {
                itemList.add((Object)stack.func_77955_b(new CompoundNBT()));
            }
            compound.func_218657_a("Items", (INBT)itemList);
        }
        ListNBT equipmentList = new ListNBT();
        for (ItemStack stack : this.equipment) {
            equipmentList.add((Object)stack.func_77955_b(new CompoundNBT()));
        }
        compound.func_218657_a("Equipment", (INBT)equipmentList);
        compound.func_74772_a("Timestamp", this.timestamp);
        compound.func_74768_a("Experience", this.experience);
        compound.func_74780_a("PosX", this.posX);
        compound.func_74780_a("PosY", this.posY);
        compound.func_74780_a("PosZ", this.posZ);
        compound.func_74778_a("Dimension", this.dimension);
        return compound;
    }
}

