/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import de.maxhenkel.corpse.DataSerializerItemList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class CorpseInventoryBaseEntity
extends Entity
implements IInventory {
    private static final DataParameter<Integer> INVENTORY_SIZE = EntityDataManager.func_187226_a(CorpseInventoryBaseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<NonNullList<ItemStack>> EQUIPMENT = EntityDataManager.func_187226_a(CorpseInventoryBaseEntity.class, DataSerializerItemList.ITEM_LIST);
    protected IInventory inventory;
    private InvWrapper handler;

    public CorpseInventoryBaseEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void setEquipment(NonNullList<ItemStack> equipment) {
        this.field_70180_af.func_187227_b(EQUIPMENT, equipment);
    }

    public NonNullList<ItemStack> getEquipment() {
        return (NonNullList)this.field_70180_af.func_187225_a(EQUIPMENT);
    }

    private IInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new Inventory(this.getFittingInventorySize((Integer)this.field_70180_af.func_187225_a(INVENTORY_SIZE)));
        }
        return this.inventory;
    }

    private int getFittingInventorySize(int size) {
        if (size < 54) {
            size = 54;
        }
        if (size % 54 != 0) {
            size += 54 - size % 54;
        }
        return size;
    }

    public void setItems(NonNullList<ItemStack> items) {
        this.field_70180_af.func_187227_b(INVENTORY_SIZE, (Object)items.size());
        for (int i = 0; i < this.func_70302_i_() && i < items.size(); ++i) {
            this.func_70299_a(i, (ItemStack)items.get(i));
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(INVENTORY_SIZE, (Object)54);
        this.field_70180_af.func_187214_a(EQUIPMENT, (Object)NonNullList.func_191197_a((int)EquipmentSlotType.values().length, (Object)ItemStack.field_190927_a));
    }

    protected void func_70037_a(CompoundNBT compound) {
        int size = compound.func_74762_e("InventorySize");
        ListNBT inv = compound.func_150295_c("Inventory", 10);
        this.inventory = new Inventory(size);
        for (int i = 0; i < inv.size(); ++i) {
            CompoundNBT slot = inv.func_150305_b(i);
            int j = slot.func_74762_e("Slot");
            if (j < 0 || j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)slot));
        }
        ListNBT equip = compound.func_150295_c("Equipment", 10);
        NonNullList equipment = NonNullList.func_191197_a((int)EquipmentSlotType.values().length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < equip.size(); ++i) {
            CompoundNBT stack = equip.func_150305_b(i);
            equipment.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)stack));
        }
        this.setEquipment((NonNullList<ItemStack>)equipment);
    }

    protected void func_213281_b(CompoundNBT compound) {
        ListNBT inv = new ListNBT();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            CompoundNBT slot = new CompoundNBT();
            slot.func_74768_a("Slot", i);
            this.func_70301_a(i).func_77955_b(slot);
            inv.add((Object)slot);
        }
        compound.func_218657_a("Inventory", (INBT)inv);
        compound.func_74768_a("InventorySize", this.func_70302_i_());
        ListNBT equip = new ListNBT();
        for (ItemStack stack : this.getEquipment()) {
            CompoundNBT slot = new CompoundNBT();
            stack.func_77955_b(slot);
            equip.add((Object)slot);
        }
        compound.func_218657_a("Equipment", (INBT)equip);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_70128_L && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(this::getItemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public InvWrapper getItemHandler() {
        if (this.handler == null || this.handler.getInv() != this.getInventory()) {
            this.handler = new InvWrapper(this.getInventory());
        }
        return this.handler;
    }

    public void func_70106_y() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)this.func_70304_b(i));
        }
        super.func_70106_y();
    }

    public int func_70302_i_() {
        return this.getInventory().func_70302_i_();
    }

    public boolean func_191420_l() {
        return this.getInventory().func_191420_l();
    }

    public ItemStack func_70301_a(int index) {
        return this.getInventory().func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.getInventory().func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.getInventory().func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getInventory().func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.getInventory().func_70297_j_();
    }

    public void func_70296_d() {
        this.getInventory().func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.getInventory().func_70300_a(player);
    }

    public void func_174889_b(PlayerEntity player) {
        this.getInventory().func_174889_b(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.getInventory().func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.getInventory().func_94041_b(index, stack);
    }

    public void func_174888_l() {
        this.getInventory().func_174888_l();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

