/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.CachedMap;
import de.maxhenkel.corpse.corelib.client.PlayerSkins;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.entities.DummyPlayer;
import de.maxhenkel.corpse.entities.DummyPlayerRenderer;
import de.maxhenkel.corpse.entities.DummySkeleton;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class CorpseRenderer
extends EntityRenderer<CorpseEntity> {
    private final CachedMap<CorpseEntity, DummyPlayer> players = new CachedMap(10000L);
    private final CachedMap<CorpseEntity, DummySkeleton> skeletons = new CachedMap(10000L);
    private final DummyPlayerRenderer playerRenderer;
    private final DummyPlayerRenderer playerRendererSmallArms;
    private final SkeletonRenderer skeletonRenderer;

    public CorpseRenderer(EntityRendererManager renderManager) {
        super(renderManager);
        this.playerRenderer = new DummyPlayerRenderer(renderManager, false);
        this.playerRendererSmallArms = new DummyPlayerRenderer(renderManager, true);
        this.skeletonRenderer = new SkeletonRenderer(renderManager);
    }

    public ResourceLocation getEntityTexture(CorpseEntity entity) {
        return null;
    }

    public void render(CorpseEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLightIn) {
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLightIn);
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-entity.getCorpseRotation()));
        if (((Boolean)Main.SERVER_CONFIG.spawnCorpseOnFace.get()).booleanValue()) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStack.func_227861_a_(0.0, -1.0, -0.125625);
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            matrixStack.func_227861_a_(0.0, -1.0, 0.125625);
        }
        if (entity.isSkeleton()) {
            DummySkeleton skeleton = this.skeletons.get(entity, () -> new DummySkeleton(entity.field_70170_p, entity.getEquipment()));
            this.skeletonRenderer.func_225623_a_((MobEntity)skeleton, entityYaw, 1.0f, matrixStack, buffer, packedLightIn);
        } else {
            AbstractClientPlayerEntity abstractClientPlayerEntity = (AbstractClientPlayerEntity)this.players.get(entity, () -> new DummyPlayer((ClientWorld)entity.field_70170_p, new GameProfile(entity.getCorpseUUID(), entity.getCorpseName()), entity.getEquipment()));
            if (PlayerSkins.isSlim(entity.getCorpseUUID())) {
                this.playerRendererSmallArms.func_225623_a_(abstractClientPlayerEntity, 0.0f, 1.0f, matrixStack, buffer, packedLightIn);
            } else {
                this.playerRenderer.func_225623_a_(abstractClientPlayerEntity, 0.0f, 1.0f, matrixStack, buffer, packedLightIn);
            }
        }
        matrixStack.func_227865_b_();
    }
}

