/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.inventory.ContainerBase;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseSlot;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class CorpseContainer
extends ContainerBase {
    private CorpseEntity corpse;
    private PlayerMainInvWrapper playerInventory;
    private boolean editable;
    private boolean history;

    public CorpseContainer(int id, PlayerInventory playerInventory, CorpseEntity corpse, boolean editable, boolean history) {
        super(Main.CONTAINER_TYPE_CORPSE, id, (IInventory)playerInventory, corpse);
        this.corpse = corpse;
        this.playerInventory = new PlayerMainInvWrapper(playerInventory);
        this.editable = editable;
        this.history = history;
        this.setSlots(0);
    }

    public CorpseContainer(int id, PlayerInventory playerInventory, CorpseEntity corpse) {
        this(id, playerInventory, corpse, false, true);
    }

    public void setSlots(int start) {
        this.field_75151_b.clear();
        for (int j = 0; j < 6; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new CorpseSlot(this.corpse, start + k + j * 9, 8 + k * 18, 19 + j * 18, this.editable));
            }
        }
        this.addPlayerInventorySlots();
        this.func_75142_b();
    }

    public CorpseEntity getCorpse() {
        return this.corpse;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isHistory() {
        return this.history;
    }

    public void transferItems() {
        if (!this.isEditable()) {
            return;
        }
        block0: for (int i = 0; i < this.corpse.func_70302_i_(); ++i) {
            ItemStack stack = this.corpse.func_70301_a(i);
            for (int j = 0; j < this.playerInventory.getSlots(); ++j) {
                stack = this.playerInventory.insertItem(j, stack, false);
                this.corpse.func_70299_a(i, stack);
                if (stack.func_190926_b()) continue block0;
            }
        }
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        if (this.history) {
            return true;
        }
        return this.corpse.func_70300_a(player) && this.corpse.func_70032_d((Entity)player) < 8.0f && this.corpse.func_70089_S();
    }

    @Override
    public int getInvOffset() {
        return 82;
    }

    @Override
    public int getInventorySize() {
        return 54;
    }
}

