/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.energy;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyStorageItem
extends EnergyStorage {
    private ItemStack container;

    public EnergyStorageItem(ItemStack stack, int capacity) {
        super(capacity);
        this.container = stack;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.container.func_77942_o()) {
            this.container.func_77982_d(new NBTTagCompound());
        }
        int energy = this.container.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.container.func_77978_p() == null || !this.container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        int energy = this.container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        if (this.container.func_77978_p() == null || !this.container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        return this.container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

