/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.atesab.customcursormod.Configuration;
import fr.atesab.customcursormod.CursorClick;
import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorType;
import fr.atesab.customcursormod.gui.GuiConfigCursorMod;
import fr.atesab.customcursormod.gui.GuiCursorModFactory;
import fr.atesab.customcursormod.gui.GuiSelectZone;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

@Mod.EventBusSubscriber(modid="customcursormod")
@Mod(value="customcursormod")
@OnlyIn(value=Dist.CLIENT)
public class CursorMod {
    public static final String MOD_GUI_FACTORY = "fr.atesab.customcursormod.gui.GuiCursorModFactory";
    public static final String MOD_ID = "customcursormod";
    public static final String MOD_NAME = "Custom Cursor Mod";
    public static final String MOD_VERSION = "1.2.3";
    private static Configuration config = new Configuration();
    private static CursorType currentCursorType;
    private static Queue<CursorClick> cursorClicks;
    private static final GuiCursorModFactory factory;
    private static boolean forceNextCursor;
    private static final Gson gson;
    public static final Logger logger;
    private static final File saveFile;

    private static void changeCursor(CursorType cursor) {
        CursorMod.changeCursor(cursor, forceNextCursor);
        forceNextCursor = false;
    }

    private static void changeCursor(CursorType cursor, boolean forceChange) {
        if (cursor.equals(currentCursorType) && !forceChange) {
            return;
        }
        currentCursorType = cursor;
        try {
            CursorConfig cursorConfig = config.getCursors().getOrDefault(cursor, cursor.getDefaultConfig());
            IResource src = cursorConfig.getResource();
            if (src == null) {
                return;
            }
            BufferedImage image = ImageIO.read(src.func_199027_b());
            int w = image.getWidth();
            int h = image.getHeight();
            int numImg = image.getHeight() / image.getWidth();
            int[] pixels = new int[w * h];
            image.getRGB(0, 0, w, h, pixels, 0, w);
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(w * h * 4));
            IntBuffer delayBuffer = BufferUtils.createIntBuffer((int)(numImg * 2));
            for (int i = 0; i < numImg; ++i) {
                delayBuffer.put(cursor.getAnimationDelays());
                for (int y = (i + 1) * w - 1; y >= i * w; --y) {
                    for (int x = 0; x < w; ++x) {
                        int pixel = pixels[((i + 1) * w - 1 - y) * w + x];
                        buffer.put((byte)(pixel >> 16 & 0xFF)).put((byte)(pixel >> 8 & 0xFF)).put((byte)(pixel & 0xFF)).put((byte)(pixel >> 24 & 0xFF));
                    }
                }
            }
            buffer.flip();
            GLFWImage cursorImg = GLFWImage.create();
            cursorImg.width(w);
            cursorImg.height(w);
            cursorImg.pixels(buffer);
            long cursorID = GLFW.glfwCreateCursor((GLFWImage)cursorImg, (int)cursorConfig.getxHotSpot(), (int)cursorConfig.getyHotSpot());
            GLFW.glfwSetCursor((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (long)cursorID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void forceNextCursor() {
        forceNextCursor = config.isDynamicCursor();
    }

    public static Configuration getConfig() {
        return config;
    }

    public static Map<CursorType, CursorConfig> getCursors() {
        return config.getCursors();
    }

    private static boolean isHover(int mouseX, int mouseY, int x, int y, int width, int height) {
        x = Math.min(x + width, x);
        y = Math.min(y + height, y);
        width = Math.abs(width);
        height = Math.abs(height);
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private static boolean isHoverButton(int mouseX, int mouseY, GuiButton button) {
        return button != null && button.field_146125_m && button.field_146124_l && CursorMod.isHover(mouseX, mouseY, button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g);
    }

    private static boolean isHoverTextField(int mouseX, int mouseY, GuiTextField textField) {
        return textField != null && textField.func_146176_q() && CursorMod.isHover(mouseX, mouseY, textField.field_146209_f, textField.field_146210_g, textField.field_146218_h, textField.field_146219_i);
    }

    public static void registerCursor(CursorType ... cursorTypes) {
        for (CursorType cursorType : cursorTypes) {
            config.getCursors().put(cursorType, cursorType.getDefaultConfig());
        }
    }

    public static void saveConfig() {
        try {
            saveFile.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(saveFile);
            gson.toJson((Object)config, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CursorMod.changeCursor(currentCursorType, true);
    }

    @Deprecated
    public static void setCursors(Map<CursorType, CursorConfig> cursors) {
        config.setCursors(cursors);
    }

    public static void syncConfig() {
        Set<CursorType> types = CursorMod.getConfig().getCursors().keySet();
        try {
            FileReader reader = new FileReader(saveFile);
            config = (Configuration)gson.fromJson((Reader)reader, Configuration.class);
            ((Reader)reader).close();
            if (config == null) {
                config = new Configuration();
            }
        }
        catch (FileNotFoundException reader) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            types.forEach(type -> config.getCursors().computeIfAbsent((CursorType)type, t -> t.getDefaultConfig()));
            CursorMod.saveConfig();
        }
    }

    public CursorMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::preInit);
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post ev) {
        GuiScreen gui = ev.getGui();
        CursorType newCursorType = CursorType.POINTER;
        if (config.isDynamicCursor()) {
            ITextComponent ichatcomponent;
            for (IGuiEventListener o : gui.func_195074_b()) {
                try {
                    if (o == null) continue;
                    if (o instanceof GuiTextField) {
                        if (!CursorMod.isHoverTextField(ev.getMouseX(), ev.getMouseY(), (GuiTextField)o)) continue;
                        newCursorType = CursorType.BEAM;
                        continue;
                    }
                    if (o instanceof GuiButton) {
                        if (!CursorMod.isHoverButton(ev.getMouseX(), ev.getMouseY(), (GuiButton)o)) continue;
                        newCursorType = CursorType.HAND;
                        continue;
                    }
                    if (!(o instanceof GuiSelectZone)) continue;
                    GuiSelectZone selectZone = (GuiSelectZone)o;
                    if (!CursorMod.isHover(ev.getMouseX(), ev.getMouseY(), selectZone.getxPosition(), selectZone.getyPosition(), selectZone.getWidth(), selectZone.getHeight()) || !selectZone.isEnable()) continue;
                    newCursorType = CursorType.CROSS;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (gui instanceof GuiContainer) {
                GuiContainer container = (GuiContainer)gui;
                if (gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o() != null && gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_77973_b() != Items.field_190931_a) {
                    newCursorType = CursorType.HAND_GRAB;
                } else if (container.getSlotUnderMouse() != null && container.getSlotUnderMouse().func_75216_d()) {
                    newCursorType = CursorType.HAND;
                }
            } else if (gui instanceof GuiChat && (ichatcomponent = gui.field_146297_k.field_71456_v.func_146158_b().func_194817_a((double)ev.getMouseX(), (double)ev.getMouseY())) != null && ichatcomponent.func_150256_b().func_150235_h() != null) {
                newCursorType = CursorType.HAND;
            }
            for (CursorType cursorType : config.getCursors().keySet()) {
                if (cursorType.getCursorTester() == null || !cursorType.getCursorTester().testCursor(newCursorType, gui, ev.getMouseX(), ev.getMouseY(), ev.getRenderPartialTicks())) continue;
                newCursorType = cursorType;
                break;
            }
        }
        CursorMod.changeCursor(newCursorType);
        if (config.isClickAnimation()) {
            Iterator iterator = cursorClicks.iterator();
            while (iterator.hasNext()) {
                CursorClick cursorClick = (CursorClick)iterator.next();
                gui.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("customcursormod:textures/gui/click_" + (2 - cursorClick.getTime()) + ".png"));
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                Gui.func_152125_a((int)((int)cursorClick.getPosX() - 8), (int)((int)cursorClick.getPosY() - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16, (float)16.0f, (float)16.0f);
                cursorClick.descreaseTime();
                if (cursorClick.getTime() >= 0) continue;
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    public void onGuiCloses(TickEvent.ClientTickEvent ev) {
        if (!cursorClicks.isEmpty() && Minecraft.func_71410_x().field_71462_r == null) {
            cursorClicks.clear();
        }
    }

    @SubscribeEvent
    public void onInitScreen(GuiScreenEvent.InitGuiEvent.Post ev) {
        forceNextCursor = true;
        if (CursorMod.getConfig().isShowCursorModButton() && ev.getGui() instanceof GuiMainMenu) {
            final GuiMainMenu gui = (GuiMainMenu)ev.getGui();
            ev.addButton(new GuiButton(-256654, gui.field_146294_l - 100, 0, 100, 20, MOD_NAME){

                public void func_194829_a(double mouseX, double mouseY) {
                    gui.field_146297_k.func_147108_a(factory.createConfigGui((GuiScreen)gui));
                    super.func_194829_a(mouseX, mouseY);
                }
            });
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onMouseInput(GuiScreenEvent.MouseClickedEvent.Pre ev) {
        if (ev.getButton() == 0 && config.isClickAnimation()) {
            cursorClicks.add(new CursorClick(ev.getMouseX(), ev.getMouseY()));
        }
    }

    public void preInit(FMLClientSetupEvent ev) {
        currentCursorType = CursorType.POINTER;
        CursorMod.registerCursor(currentCursorType, CursorType.HAND, CursorType.HAND_GRAB, CursorType.BEAM, CursorType.CROSS);
        CursorMod.syncConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModList.get().getModContainerById(MOD_ID).ifPresent(modContainer -> modContainer.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, parent) -> new GuiConfigCursorMod((GuiScreen)parent)));
    }

    static {
        cursorClicks = new LinkedList<CursorClick>();
        factory = new GuiCursorModFactory();
        forceNextCursor = false;
        gson = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().create();
        logger = Logger.getLogger(MOD_NAME);
        saveFile = new File(new File(new File(Minecraft.func_71410_x().field_71412_D, "mods"), "CursorMod"), "config.json");
    }
}

