/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.gui;

import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorMod;
import fr.atesab.customcursormod.CursorType;
import fr.atesab.customcursormod.gui.GuiCursorConfig;
import fr.atesab.customcursormod.gui.GuiValueButton;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class GuiConfigCursorMod
extends GuiScreen {
    private List<GuiValueButton<CursorType>> cursorButtons = new ArrayList<GuiValueButton<CursorType>>();
    private Map<CursorType, CursorConfig> cursors;
    private int elementByPage = 1;
    private GuiButton lastPage;
    private GuiButton nextPage;
    private int page = 0;
    private GuiScreen parent;

    public GuiConfigCursorMod(GuiScreen parent) {
        this.parent = parent;
        this.cursors = new HashMap<CursorType, CursorConfig>(CursorMod.getCursors());
    }

    private void defineButton() {
        if (this.lastPage != null) {
            boolean bl = this.lastPage.field_146124_l = this.page > 0;
        }
        if (this.nextPage != null) {
            this.nextPage.field_146124_l = this.page < this.cursors.size() / this.elementByPage;
        }
        for (int i = 0; i < this.cursorButtons.size(); ++i) {
            this.cursorButtons.get((int)i).field_146125_m = i < (this.page + 1) * this.elementByPage && i >= this.page * this.elementByPage;
        }
    }

    private void drawCursor(int posX, int posY, CursorConfig cursorConfig) {
        try {
            BufferedImage image = ImageIO.read(cursorConfig.getResource().func_199027_b());
            int imageWidth = image.getWidth();
            int imageHeight = image.getWidth();
            int numImage = image.getHeight() / image.getWidth();
            this.func_73733_a(posX, posY, posX + 20, posY + 20, -1072689136, -804253680);
            this.field_146297_k.func_110434_K().func_110577_a(cursorConfig.getResourceLocation());
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GuiConfigCursorMod.func_152125_a((int)posX, (int)posY, (float)0.0f, (float)0.0f, (int)imageWidth, (int)imageHeight, (int)20, (int)20, (float)imageWidth, (float)(imageHeight * numImage));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_73866_w_() {
        this.page = 0;
        this.elementByPage = (this.field_146295_m - 42) / 21;
        if (this.elementByPage > 10) {
            this.elementByPage = 10;
        }
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 79, this.field_146295_m / 2 + this.elementByPage / 2 * 21, 158, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                CursorMod.setCursors(GuiConfigCursorMod.this.cursors);
                CursorMod.saveConfig();
                GuiConfigCursorMod.this.field_146297_k.func_147108_a(GuiConfigCursorMod.this.parent);
                super.func_194829_a(mouseX, mouseY);
            }
        });
        if (this.elementByPage >= this.cursors.size()) {
            this.lastPage = new GuiButton(1, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + this.elementByPage / 2 * 21, 20, 20, "<"){

                public void func_194829_a(double mouseX, double mouseY) {
                    GuiConfigCursorMod.this.page--;
                    GuiConfigCursorMod.this.defineButton();
                    super.func_194829_a(mouseX, mouseY);
                }
            };
            this.func_189646_b(this.lastPage);
            this.nextPage = new GuiButton(2, this.field_146294_l / 2 + 80, this.field_146295_m / 2 + this.elementByPage / 2 * 21, 20, 20, ">"){

                public void func_194829_a(double mouseX, double mouseY) {
                    GuiConfigCursorMod.this.page++;
                    GuiConfigCursorMod.this.defineButton();
                    super.func_194829_a(mouseX, mouseY);
                }
            };
            this.func_189646_b(this.nextPage);
        } else {
            this.nextPage = null;
            this.lastPage = null;
        }
        int i = -1;
        this.cursorButtons.clear();
        for (CursorType cursorType : this.cursors.keySet()) {
            this.cursorButtons.add(new GuiValueButton<CursorType>(3, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + (i++ % this.elementByPage - this.elementByPage / 2) * 21, 200, 20, cursorType.getName(), cursorType){

                public void func_194829_a(double mouseX, double mouseY) {
                    final CursorType type = (CursorType)this.getValue();
                    GuiConfigCursorMod.this.field_146297_k.func_147108_a((GuiScreen)new GuiCursorConfig(GuiConfigCursorMod.this, type, (CursorConfig)GuiConfigCursorMod.this.cursors.get(type)){

                        @Override
                        protected void saveConfig(CursorConfig cursorConfig) {
                            GuiConfigCursorMod.this.cursors.put(type, cursorConfig);
                            CursorMod.forceNextCursor();
                        }
                    });
                    super.func_194829_a(mouseX, mouseY);
                }
            });
        }
        for (GuiButton guiButton : this.cursorButtons) {
            this.func_189646_b(guiButton);
        }
        this.defineButton();
        super.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, "Custom Cursor Mod v1.2.3", this.field_146294_l / 2, this.field_146295_m / 2 - (this.elementByPage / 2 + 2) * 21, Color.ORANGE.getRGB());
        for (int i = this.page * this.elementByPage; i < this.cursorButtons.size() && i < (this.page + 1) * this.elementByPage; ++i) {
            GuiValueButton<CursorType> button = this.cursorButtons.get(i);
            this.drawCursor(button.field_146128_h + button.field_146120_f + 1, button.field_146129_i, this.cursors.get(button.getValue()));
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

