/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.gui;

import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorType;
import fr.atesab.customcursormod.gui.GuiSelectZone;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public abstract class GuiCursorConfig
extends GuiScreen {
    private CursorConfig cursorConfig;
    private GuiTextField cursorLocation;
    private GuiButton doneButton;
    private int imageHeight = 1;
    private int imageWidth = 1;
    private int numImage = 1;
    private final CursorConfig oldCursorConfig;
    private GuiScreen parent;
    private GuiSelectZone selectZone;
    private final CursorType type;
    private GuiTextField xhotspot;
    private GuiTextField yhotspot;

    public GuiCursorConfig(GuiScreen parent, CursorType type, CursorConfig cursorConfig) {
        this.parent = parent;
        this.type = type;
        this.cursorConfig = cursorConfig.copy();
        this.oldCursorConfig = this.cursorConfig.copy();
    }

    private void drawCenterString(String text, int x, int y, int HEIGHT, int color) {
        this.field_146289_q.func_175063_a(text, (float)(x - this.field_146289_q.func_78256_a(text) / 2), (float)(y + HEIGHT / 2 - this.field_146289_q.field_78288_b / 2), color);
    }

    private void drawRightString(String text, int x, int y, int HEIGHT, int color) {
        this.field_146289_q.func_175063_a(text, (float)(x - this.field_146289_q.func_78256_a(text)), (float)(y + HEIGHT / 2 - this.field_146289_q.field_78288_b / 2), color);
    }

    public void func_73866_w_() {
        this.syncImageSize();
        this.xhotspot = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 99, this.field_146295_m / 2 - 41, 124, 18);
        this.field_195124_j.add(this.xhotspot);
        this.yhotspot = new GuiTextField(1, this.field_146289_q, this.field_146294_l / 2 - 99, this.field_146295_m / 2 - 20, 124, 18);
        this.field_195124_j.add(this.yhotspot);
        this.cursorLocation = new GuiTextField(2, this.field_146289_q, this.field_146294_l / 2 - 99, this.field_146295_m / 2 + 1, 124, 18);
        this.field_195124_j.add(this.cursorLocation);
        this.cursorLocation.func_146203_f(Integer.MAX_VALUE);
        this.updateCursorValues(this.cursorConfig);
        this.selectZone = new GuiSelectZone(this.field_146294_l / 2 + 36, this.field_146295_m / 2 - 64, 128, 128);
        this.field_195124_j.add(this.selectZone);
        this.func_189646_b(new GuiButton(2, this.field_146294_l / 2 - 174, this.field_146295_m / 2 + 21, I18n.func_135052_a((String)"cursormod.gui.default", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiCursorConfig.this.updateCursorValues(GuiCursorConfig.this.type.getDefaultConfig());
                super.func_194829_a(mouseX, mouseY);
            }
        });
        this.doneButton = new GuiButton(0, this.field_146294_l / 2 - 174, this.field_146295_m / 2 + 42, 100, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiCursorConfig.this.saveConfig(GuiCursorConfig.this.cursorConfig);
                GuiCursorConfig.this.field_146297_k.func_147108_a(GuiCursorConfig.this.parent);
                super.func_194829_a(mouseX, mouseY);
            }
        };
        this.func_189646_b(this.doneButton);
        this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 - 72, this.field_146295_m / 2 + 42, 99, 20, I18n.func_135052_a((String)"cursormod.gui.cancel", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiCursorConfig.this.saveConfig(GuiCursorConfig.this.oldCursorConfig);
                GuiCursorConfig.this.field_146297_k.func_147108_a(GuiCursorConfig.this.parent);
                super.func_194829_a(mouseX, mouseY);
            }
        });
        super.func_73866_w_();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseX >= (double)(this.field_146294_l / 2 + 36) && mouseY >= (double)(this.field_146295_m / 2 - 64) && mouseX <= (double)(this.field_146294_l / 2 + 164) && mouseY <= (double)(this.field_146295_m / 2 + 64)) {
            this.cursorConfig.setxHotSpot(MathHelper.func_76125_a((int)((int)((float)(mouseX - (double)(this.field_146294_l / 2 + 36)) * (float)this.imageWidth / 128.0f)), (int)0, (int)(this.imageWidth - 1)));
            this.cursorConfig.setyHotSpot(MathHelper.func_76125_a((int)((int)((float)(mouseY - (double)(this.field_146295_m / 2 - 64)) * (float)this.imageHeight / 128.0f)), (int)0, (int)(this.imageWidth - 1)));
            this.xhotspot.func_146180_a(String.valueOf(this.cursorConfig.getxHotSpot()));
            this.yhotspot.func_146180_a(String.valueOf(this.cursorConfig.getyHotSpot()));
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.xhotspot.func_195608_a(mouseX, mouseY, partialTicks);
        this.yhotspot.func_195608_a(mouseX, mouseY, partialTicks);
        this.cursorLocation.func_195608_a(mouseX, mouseY, partialTicks);
        this.drawCenterString(this.type.getName(), this.field_146294_l / 2 - 74, this.field_146295_m / 2 - 41 - 21, 20, Color.ORANGE.getRGB());
        this.drawRightString(I18n.func_135052_a((String)"cursormod.config.xhotspot", (Object[])new Object[0]) + " : ", this.xhotspot.field_146209_f, this.xhotspot.field_146210_g, this.xhotspot.field_146219_i, Color.WHITE.getRGB());
        this.drawRightString(I18n.func_135052_a((String)"cursormod.config.yhotspot", (Object[])new Object[0]) + " : ", this.yhotspot.field_146209_f, this.yhotspot.field_146210_g, this.yhotspot.field_146219_i, Color.WHITE.getRGB());
        this.drawRightString(I18n.func_135052_a((String)"cursormod.config.location", (Object[])new Object[0]) + " : ", this.cursorLocation.field_146209_f, this.cursorLocation.field_146210_g, this.cursorLocation.field_146219_i, Color.WHITE.getRGB());
        if (this.syncImageSize()) {
            this.field_146297_k.func_110434_K().func_110577_a(this.cursorConfig.getResourceLocation());
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73733_a(this.field_146294_l / 2 + 36, this.field_146295_m / 2 - 64, this.field_146294_l / 2 + 164, this.field_146295_m / 2 + 64, -1072689136, -804253680);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GuiCursorConfig.func_152125_a((int)(this.field_146294_l / 2 + 36), (int)(this.field_146295_m / 2 - 64), (float)0.0f, (float)0.0f, (int)this.imageWidth, (int)this.imageHeight, (int)128, (int)128, (float)this.imageWidth, (float)(this.imageHeight * this.numImage));
            if (this.cursorConfig.getxHotSpot() >= 0 && this.cursorConfig.getxHotSpot() < this.imageWidth && this.cursorConfig.getyHotSpot() >= 0 && this.cursorConfig.getyHotSpot() < this.imageHeight) {
                this.func_73732_a(this.field_146289_q, "+", this.field_146294_l / 2 + 36 + (int)((float)this.cursorConfig.getxHotSpot() * 128.0f / (float)this.imageWidth), this.field_146295_m / 2 - 64 + (int)((float)this.cursorConfig.getyHotSpot() * 128.0f / (float)this.imageHeight) - this.field_146289_q.field_78288_b / 2, Color.WHITE.getRGB());
            }
            if (this.numImage > 1) {
                this.func_73732_a(this.field_146289_q, "(" + I18n.func_135052_a((String)"cursormod.gui.animate", (Object[])new Object[0]) + ")", this.field_146294_l / 2 + 100, this.field_146295_m / 2 + 64 + 1, Color.WHITE.getRGB());
            }
            this.selectZone.setEnable(true);
        } else {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"cursormod.gui.error", (Object[])new Object[0]), this.field_146294_l / 2 + 100, this.field_146295_m / 2 - this.field_146289_q.field_78288_b / 2, Color.RED.getRGB());
            this.selectZone.setEnable(false);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected abstract void saveConfig(CursorConfig var1);

    private boolean syncImageSize() {
        try {
            BufferedImage image = ImageIO.read(this.cursorConfig.getResource().func_199027_b());
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getWidth();
            this.numImage = image.getHeight() / image.getWidth();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void func_73876_c() {
        this.xhotspot.func_146178_a();
        this.yhotspot.func_146178_a();
        this.cursorLocation.func_146178_a();
        this.verifyValue();
        super.func_73876_c();
    }

    private void updateCursorValues(CursorConfig cursorConfig) {
        this.cursorConfig = cursorConfig;
        this.xhotspot.func_146180_a(String.valueOf(cursorConfig.getxHotSpot()));
        this.yhotspot.func_146180_a(String.valueOf(cursorConfig.getyHotSpot()));
        this.cursorLocation.func_146180_a(cursorConfig.getLink());
    }

    private void verifyValue() {
        boolean flag = this.syncImageSize();
        try {
            this.cursorConfig.setxHotSpot(Integer.valueOf(this.xhotspot.func_146179_b()));
            if (this.cursorConfig.getxHotSpot() >= 0 && this.cursorConfig.getxHotSpot() < this.imageWidth) {
                this.xhotspot.func_146193_g(Color.WHITE.getRGB());
            } else {
                this.xhotspot.func_146193_g(Color.RED.getRGB());
                flag = false;
            }
        }
        catch (Exception e) {
            this.xhotspot.func_146193_g(Color.RED.getRGB());
            flag = false;
        }
        try {
            this.cursorConfig.setyHotSpot(Integer.valueOf(this.yhotspot.func_146179_b()));
            if (this.cursorConfig.getyHotSpot() >= 0 && this.cursorConfig.getyHotSpot() < this.imageHeight) {
                this.yhotspot.func_146193_g(Color.WHITE.getRGB());
            } else {
                this.yhotspot.func_146193_g(Color.RED.getRGB());
                flag = false;
            }
        }
        catch (Exception e) {
            this.yhotspot.func_146193_g(Color.RED.getRGB());
            flag = false;
        }
        this.cursorConfig.setLink(this.cursorLocation.func_146179_b());
        this.doneButton.field_146124_l = flag;
    }
}

