/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.gui;

import fr.atesab.customcursormod.Configuration;
import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorMod;
import fr.atesab.customcursormod.CursorType;
import fr.atesab.customcursormod.gui.GuiBooleanButton;
import fr.atesab.customcursormod.gui.GuiConfigCursorMod;
import fr.atesab.customcursormod.gui.GuiCursorConfig;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class GuiConfig
extends Screen {
    private Screen parent;

    public GuiConfig(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("cursormod.gui.config", new Object[0]));
        this.parent = parent;
    }

    private void drawScaledCenterString(String text, float x, float y, int color, float factor) {
        this.drawScaledString(text, x - (float)this.font.func_78256_a(text) * factor / 2.0f, y, color, factor);
    }

    private void drawScaledString(String text, float x, float y, int color, float factor) {
        GL11.glScalef((float)factor, (float)factor, (float)factor);
        this.font.func_175063_a(text, x / factor, y / factor, color);
        GL11.glScalef((float)(1.0f / factor), (float)(1.0f / factor), (float)(1.0f / factor));
    }

    public void init() {
        Configuration cfg = CursorMod.getConfig();
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 2 + 24, 200, 20, I18n.func_135052_a((String)"menu.options", (Object[])new Object[0]), b -> {
            if (cfg.dynamicCursor) {
                this.getMinecraft().func_147108_a((Screen)new GuiConfigCursorMod(this));
            } else {
                CursorConfig ccfg = CursorMod.getCursors().get(CursorType.POINTER);
                this.getMinecraft().func_147108_a((Screen)new GuiCursorConfig(this, CursorType.POINTER, ccfg){

                    @Override
                    protected void saveConfig(CursorConfig cursorConfig) {
                        CursorMod.replaceCursor(CursorType.POINTER, cursorConfig);
                    }
                });
            }
        }));
        this.addButton((Widget)new GuiBooleanButton(this.width / 2 - 100, this.height / 2, 200, 20, I18n.func_135052_a((String)"cursormod.config.dynCursor", (Object[])new Object[0]), cfg::setDynamicCursor, cfg::isDynamicCursor));
        this.addButton((Widget)new GuiBooleanButton(this.width / 2 - 100, this.height / 2 - 24, 200, 20, I18n.func_135052_a((String)"cursormod.config.clickAnim", (Object[])new Object[0]), cfg::setClickAnimation, cfg::isClickAnimation));
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 2 + 48, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> {
            this.getMinecraft().func_147108_a(this.parent);
            CursorMod.saveConfig();
        }));
        super.init();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawScaledCenterString("Custom Cursor Mod 1.2.2", this.width / 2, this.height / 2 - 60, -1, 2.5f);
        super.render(mouseX, mouseY, partialTicks);
    }
}

