/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorType;
import fr.atesab.customcursormod.gui.GuiSelectZone;
import fr.atesab.customcursormod.gui.GuiUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GuiCursorConfig
extends Screen {
    private Screen parent;
    private TextFieldWidget xhotspot;
    private TextFieldWidget yhotspot;
    private TextFieldWidget cursorLocation;
    private Button doneButton;
    private GuiSelectZone selectZone;
    private int imageWidth = 1;
    private int imageHeight = 1;
    private int numImage = 1;
    private final CursorType type;
    private CursorConfig cursorConfig;

    public GuiCursorConfig(Screen parent, CursorType type, CursorConfig cursorConfig) {
        super((ITextComponent)new TranslationTextComponent("cursormod.gui.configCursor", new Object[0]));
        this.parent = parent;
        this.type = type;
        this.cursorConfig = cursorConfig.copy();
    }

    private void updateCursorValues(CursorConfig cursorConfig) {
        this.cursorConfig = cursorConfig;
        this.xhotspot.func_146180_a(String.valueOf(cursorConfig.getxHotSpot()));
        this.yhotspot.func_146180_a(String.valueOf(cursorConfig.getyHotSpot()));
        this.cursorLocation.func_146180_a(cursorConfig.getLink());
    }

    private void drawCenterString(String text, int x, int y, int HEIGHT, int color) {
        float f = x - this.font.func_78256_a(text) / 2;
        int n = y + HEIGHT / 2;
        this.font.getClass();
        this.font.func_175063_a(text, f, (float)(n - 9 / 2), color);
    }

    private void drawRightString(String text, int x, int y, int HEIGHT, int color) {
        float f = x - this.font.func_78256_a(text);
        int n = y + HEIGHT / 2;
        this.font.getClass();
        this.font.func_175063_a(text, f, (float)(n - 9 / 2), color);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.xhotspot.render(mouseX, mouseY, partialTicks);
        this.yhotspot.render(mouseX, mouseY, partialTicks);
        this.cursorLocation.render(mouseX, mouseY, partialTicks);
        this.drawCenterString(this.type.getName(), this.width / 2 - 74, this.height / 2 - 41 - 21, 20, Color.ORANGE.getRGB());
        this.drawRightString(I18n.func_135052_a((String)"cursormod.config.xhotspot", (Object[])new Object[0]) + " : ", this.xhotspot.x, this.xhotspot.y, this.xhotspot.getHeight(), Color.WHITE.getRGB());
        this.drawRightString(I18n.func_135052_a((String)"cursormod.config.yhotspot", (Object[])new Object[0]) + " : ", this.yhotspot.x, this.yhotspot.y, this.yhotspot.getHeight(), Color.WHITE.getRGB());
        this.drawRightString(I18n.func_135052_a((String)"cursormod.config.location", (Object[])new Object[0]) + " : ", this.cursorLocation.x, this.cursorLocation.y, this.cursorLocation.getHeight(), Color.WHITE.getRGB());
        if (this.syncImageSize()) {
            this.getMinecraft().func_110434_K().func_110577_a(this.cursorConfig.getResourceLocation());
            GuiUtils.drawGradientRect(this.blitOffset, this.width / 2 + 36, this.height / 2 - 64, this.width / 2 + 164, this.height / 2 + 64, -1072689136, -804253680);
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            GuiUtils.drawScaledCustomSizeModalRect(this.width / 2 + 36, this.height / 2 - 64, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 128, 128, this.imageWidth, this.imageHeight * this.numImage);
            if (this.cursorConfig.getxHotSpot() >= 0 && this.cursorConfig.getxHotSpot() < this.imageWidth && this.cursorConfig.getyHotSpot() >= 0 && this.cursorConfig.getyHotSpot() < this.imageHeight) {
                int n = this.width / 2 + 36 + (int)((float)this.cursorConfig.getxHotSpot() * 128.0f / (float)this.imageWidth);
                int n2 = this.height / 2 - 64 + (int)((float)this.cursorConfig.getyHotSpot() * 128.0f / (float)this.imageHeight);
                this.font.getClass();
                this.drawCenteredString(this.font, "+", n, n2 - 9 / 2, Color.WHITE.getRGB());
            }
            if (this.numImage > 1) {
                this.drawCenteredString(this.font, "(" + I18n.func_135052_a((String)"cursormod.gui.animate", (Object[])new Object[0]) + ")", this.width / 2 + 100, this.height / 2 + 64 + 1, Color.WHITE.getRGB());
            }
            this.selectZone.enable = true;
        } else {
            String string = I18n.func_135052_a((String)"cursormod.gui.error", (Object[])new Object[0]);
            int n = this.width / 2 + 100;
            int n3 = this.height / 2;
            this.font.getClass();
            this.drawCenteredString(this.font, string, n, n3 - 9 / 2, Color.RED.getRGB());
            this.selectZone.enable = false;
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    public void init() {
        this.syncImageSize();
        this.xhotspot = new TextFieldWidget(this.font, this.width / 2 - 99, this.height / 2 - 41, 124, 18, "");
        this.yhotspot = new TextFieldWidget(this.font, this.width / 2 - 99, this.height / 2 - 20, 124, 18, "");
        this.cursorLocation = new TextFieldWidget(this.font, this.width / 2 - 99, this.height / 2 + 1, 124, 18, "");
        this.cursorLocation.func_146203_f(Integer.MAX_VALUE);
        this.updateCursorValues(this.cursorConfig);
        this.selectZone = new GuiSelectZone(this.width / 2 + 36, this.height / 2 - 64, 128, 128);
        this.addButton((Widget)new Button(this.width / 2 - 174, this.height / 2 + 21, 200, 20, I18n.func_135052_a((String)"cursormod.gui.default", (Object[])new Object[0]), b -> this.updateCursorValues(this.type.getDefaultConfig())));
        this.doneButton = new Button(this.width / 2 - 174, this.height / 2 + 42, 100, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> {
            this.saveConfig(this.cursorConfig);
            this.getMinecraft().func_147108_a(this.parent);
        });
        this.addButton((Widget)this.doneButton);
        this.addButton((Widget)new Button(this.width / 2 - 72, this.height / 2 + 42, 99, 20, I18n.func_135052_a((String)"cursormod.gui.cancel", (Object[])new Object[0]), b -> this.getMinecraft().func_147108_a(this.parent)));
        super.init();
    }

    public boolean charTyped(char key, int modifier) {
        this.xhotspot.charTyped(key, modifier);
        this.yhotspot.charTyped(key, modifier);
        this.cursorLocation.charTyped(key, modifier);
        return super.charTyped(key, modifier);
    }

    public boolean keyPressed(int key, int scan, int modifier) {
        this.xhotspot.keyPressed(key, scan, modifier);
        this.yhotspot.keyPressed(key, scan, modifier);
        this.cursorLocation.keyPressed(key, scan, modifier);
        return super.keyPressed(key, scan, modifier);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.xhotspot.mouseClicked(mouseX, mouseY, mouseButton);
        this.yhotspot.mouseClicked(mouseX, mouseY, mouseButton);
        this.cursorLocation.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseX >= (double)(this.width / 2 + 36) && mouseY >= (double)(this.height / 2 - 64) && mouseX <= (double)(this.width / 2 + 164) && mouseY <= (double)(this.height / 2 + 64)) {
            this.cursorConfig.setxHotSpot(MathHelper.func_76125_a((int)((int)((float)(mouseX - (double)(this.width / 2 + 36)) * (float)this.imageWidth / 128.0f)), (int)0, (int)(this.imageWidth - 1)));
            this.cursorConfig.setyHotSpot(MathHelper.func_76125_a((int)((int)((float)(mouseY - (double)(this.height / 2 - 64)) * (float)this.imageHeight / 128.0f)), (int)0, (int)(this.imageWidth - 1)));
            this.xhotspot.func_146180_a(String.valueOf(this.cursorConfig.getxHotSpot()));
            this.yhotspot.func_146180_a(String.valueOf(this.cursorConfig.getyHotSpot()));
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected abstract void saveConfig(CursorConfig var1);

    private boolean syncImageSize() {
        try {
            BufferedImage image = ImageIO.read(this.cursorConfig.getResource().func_199027_b());
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getWidth();
            this.numImage = image.getHeight() / image.getWidth();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void tick() {
        this.xhotspot.func_146178_a();
        this.yhotspot.func_146178_a();
        this.cursorLocation.func_146178_a();
        this.verifyValue();
        super.tick();
    }

    private void verifyValue() {
        boolean flag = this.syncImageSize();
        try {
            this.cursorConfig.setxHotSpot(Integer.valueOf(this.xhotspot.func_146179_b()));
            if (this.cursorConfig.getxHotSpot() >= 0 && this.cursorConfig.getxHotSpot() < this.imageWidth) {
                this.xhotspot.func_146193_g(Color.WHITE.getRGB());
            } else {
                this.xhotspot.func_146193_g(Color.RED.getRGB());
                flag = false;
            }
        }
        catch (Exception e) {
            this.xhotspot.func_146193_g(Color.RED.getRGB());
            flag = false;
        }
        try {
            this.cursorConfig.setyHotSpot(Integer.valueOf(this.yhotspot.func_146179_b()));
            if (this.cursorConfig.getyHotSpot() >= 0 && this.cursorConfig.getyHotSpot() < this.imageHeight) {
                this.yhotspot.func_146193_g(Color.WHITE.getRGB());
            } else {
                this.yhotspot.func_146193_g(Color.RED.getRGB());
                flag = false;
            }
        }
        catch (Exception e) {
            this.yhotspot.func_146193_g(Color.RED.getRGB());
            flag = false;
        }
        this.cursorConfig.setLink(this.cursorLocation.func_146179_b());
        this.doneButton.active = flag;
    }
}

