/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorMod;
import fr.atesab.customcursormod.CursorType;
import java.io.File;
import java.util.Map;

public class Configuration {
    public boolean dynamicCursor = true;
    public boolean clickAnimation = true;
    private CommentedFileConfig config;

    public boolean isClickAnimation() {
        return this.clickAnimation;
    }

    public boolean isDynamicCursor() {
        return this.dynamicCursor;
    }

    public void save() {
        Map<CursorType, CursorConfig> cursors = CursorMod.getCursors();
        for (CursorType type : cursors.keySet()) {
            cursors.getOrDefault(type, cursors.get(CursorType.POINTER)).write("cursors." + type.getConfigName(), this.config);
        }
        this.config.set("general.dynamicCursor", (Object)this.dynamicCursor);
        this.config.set("general.clickAnimation", (Object)this.clickAnimation);
        this.config.save();
    }

    public void setClickAnimation(boolean clickAnimation) {
        this.clickAnimation = clickAnimation;
    }

    public void setDynamicCursor(boolean dynamicCursor) {
        this.dynamicCursor = dynamicCursor;
    }

    public void sync(File path) {
        this.config = (CommentedFileConfig)CommentedFileConfig.builder((File)path).sync().writingMode(WritingMode.REPLACE).build();
        this.config.load();
        this.config.setComment("general.dynamicCursor", "dynamicCursor");
        this.dynamicCursor = (Boolean)this.config.getOrElse("general.dynamicCursor", (Object)this.dynamicCursor);
        this.config.setComment("general.clickAnimation", "clickAnimation");
        this.clickAnimation = (Boolean)this.config.getOrElse("general.clickAnimation", (Object)this.clickAnimation);
        Map<CursorType, CursorConfig> cursors = CursorMod.getCursors();
        for (CursorType type : cursors.keySet()) {
            try {
                CursorConfig old = cursors.put(type, CursorConfig.read("cursors." + type.getConfigName(), this.config, type.getDefaultConfig()));
                if (old == null) continue;
                old.freeCursor();
            }
            catch (Exception e) {
                CursorMod.logger.warning("Can't load the cursor \"" + type.getConfigName() + "\" : " + e.getMessage());
            }
        }
        this.config.save();
    }
}

