/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorMod;
import fr.atesab.customcursormod.CursorType;
import fr.atesab.customcursormod.gui.GuiCursorConfig;
import fr.atesab.customcursormod.gui.GuiUtils;
import fr.atesab.customcursormod.gui.GuiValueButton;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiConfigCursorMod
extends Screen {
    private Screen parent;
    private Map<CursorType, CursorConfig> cursors;
    private List<GuiValueButton<CursorType>> cursorButtons = new ArrayList<GuiValueButton<CursorType>>();
    private Button lastPage;
    private Button nextPage;
    private int page = 0;
    private int elementByPage = 1;

    public GuiConfigCursorMod(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("cursormod.gui.cursorList", new Object[0]));
        this.parent = parent;
        this.cursors = CursorMod.getCursors();
    }

    private void defineButton() {
        if (this.lastPage != null) {
            boolean bl = this.lastPage.active = this.page > 0;
        }
        if (this.nextPage != null) {
            this.nextPage.active = this.page < this.cursors.size() / this.elementByPage;
        }
        for (int i = 0; i < this.cursorButtons.size(); ++i) {
            this.cursorButtons.get((int)i).visible = i < (this.page + 1) * this.elementByPage && i >= this.page * this.elementByPage;
        }
    }

    private void drawCursor(int posX, int posY, CursorConfig cursorConfig) {
        try {
            BufferedImage image = ImageIO.read(cursorConfig.getResource().func_199027_b());
            int imageWidth = image.getWidth();
            int imageHeight = image.getWidth();
            int numImage = image.getHeight() / image.getWidth();
            GuiUtils.drawGradientRect(this.getBlitOffset(), posX, posY, posX + 20, posY + 20, -1072689136, -804253680);
            this.getMinecraft().func_110434_K().func_110577_a(cursorConfig.getResourceLocation());
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            GuiUtils.drawScaledCustomSizeModalRect(posX, posY, 0.0f, 0.0f, imageWidth, imageHeight, 20, 20, imageWidth, imageHeight * numImage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        int n = this.width / 2;
        int n2 = this.height / 2;
        int n3 = (this.elementByPage / 2 + 1) * 21 + 2;
        this.font.getClass();
        this.drawCenteredString(this.font, "Custom Cursor Mod v1.2.2", n, n2 - (n3 + 9), Color.ORANGE.getRGB());
        for (int i = this.page * this.elementByPage; i < this.cursorButtons.size() && i < (this.page + 1) * this.elementByPage; ++i) {
            GuiValueButton<CursorType> button = this.cursorButtons.get(i);
            this.drawCursor(button.x + button.getWidth() + 1, button.y, this.cursors.get(button.getValue()));
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    public void init() {
        this.page = 0;
        this.elementByPage = (this.height - 63) / 21;
        if (this.elementByPage > 10) {
            this.elementByPage = 10;
        }
        this.addButton((Widget)new Button(this.width / 2 - 79, this.height / 2 + this.elementByPage / 2 * 21, 158, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> this.getMinecraft().func_147108_a(this.parent)));
        if (this.elementByPage <= this.cursors.size()) {
            this.lastPage = new Button(this.width / 2 - 100, this.height / 2 + this.elementByPage / 2 * 21, 20, 20, "<", b -> {
                --this.page;
                this.defineButton();
            });
            this.addButton((Widget)this.lastPage);
            this.nextPage = new Button(this.width / 2 + 80, this.height / 2 + this.elementByPage / 2 * 21, 20, 20, ">", b -> {
                ++this.page;
                this.defineButton();
            });
            this.addButton((Widget)this.nextPage);
        } else {
            this.nextPage = null;
            this.lastPage = null;
        }
        int i = -1;
        this.cursorButtons.clear();
        for (final CursorType type : this.cursors.keySet()) {
            this.cursorButtons.add(new GuiValueButton<CursorType>(this.width / 2 - 100, this.height / 2 + (i++ % this.elementByPage - this.elementByPage / 2) * 21, 200, 20, type.getName(), type){

                public void onPress() {
                    GuiConfigCursorMod.this.getMinecraft().func_147108_a((Screen)new GuiCursorConfig(GuiConfigCursorMod.this, type, (CursorConfig)GuiConfigCursorMod.this.cursors.get(type)){

                        @Override
                        protected void saveConfig(CursorConfig cursorConfig) {
                            CursorMod.replaceCursor(type, cursorConfig);
                        }
                    });
                }
            });
        }
        this.buttons.addAll(this.cursorButtons);
        this.children.addAll(this.cursorButtons);
        this.defineButton();
        super.init();
    }
}

