/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.gui;

import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorMod;
import fr.atesab.customcursormod.CursorType;
import fr.atesab.customcursormod.gui.GuiCursorConfig;
import fr.atesab.customcursormod.gui.GuiValueButton;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class GuiConfigCursorMod
extends GuiScreen {
    private GuiScreen parent;
    private Map<CursorType, CursorConfig> cursors;
    private List<GuiValueButton<CursorType>> cursorButtons = new ArrayList<GuiValueButton<CursorType>>();
    private GuiButton lastPage;
    private GuiButton nextPage;
    private int page = 0;
    private int elementByPage = 1;

    public GuiConfigCursorMod(GuiScreen parent) {
        this.parent = parent;
        this.cursors = new HashMap<CursorType, CursorConfig>(CursorMod.getCursors());
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            CursorMod.setCursors(this.cursors);
            CursorMod.saveConfig();
            this.field_146297_k.func_147108_a(this.parent);
        } else if (button.field_146127_k == 1) {
            --this.page;
            this.defineButton();
        } else if (button.field_146127_k == 2) {
            ++this.page;
            this.defineButton();
        } else if (button.field_146127_k == 3 && button instanceof GuiValueButton) {
            final CursorType type = (CursorType)((GuiValueButton)button).getValue();
            this.field_146297_k.func_147108_a((GuiScreen)new GuiCursorConfig(this, type, this.cursors.get(type)){

                @Override
                protected void saveConfig(CursorConfig cursorConfig) {
                    GuiConfigCursorMod.this.cursors.put(type, cursorConfig);
                    CursorMod.forceNextCursor();
                }
            });
        }
        super.func_146284_a(button);
    }

    private void defineButton() {
        if (this.lastPage != null) {
            boolean bl = this.lastPage.field_146124_l = this.page > 0;
        }
        if (this.nextPage != null) {
            this.nextPage.field_146124_l = this.page < this.cursors.size() / this.elementByPage;
        }
        for (int i = 0; i < this.cursorButtons.size(); ++i) {
            this.cursorButtons.get((int)i).field_146125_m = i < (this.page + 1) * this.elementByPage && i >= this.page * this.elementByPage;
        }
    }

    private void drawCursor(int posX, int posY, CursorConfig cursorConfig) {
        try {
            BufferedImage image = ImageIO.read(cursorConfig.getResource().func_110527_b());
            int imageWidth = image.getWidth();
            int imageHeight = image.getWidth();
            int numImage = image.getHeight() / image.getWidth();
            this.func_73733_a(posX, posY, posX + 20, posY + 20, -1072689136, -804253680);
            this.field_146297_k.func_110434_K().func_110577_a(cursorConfig.getResourceLocation());
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiConfigCursorMod.drawScaledCustomSizeModalRect(posX, posY, 0.0f, 0.0f, imageWidth, imageHeight, 20, 20, imageWidth, imageHeight * numImage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, "Custom Cursor Mod v1.2.1", this.field_146294_l / 2, this.field_146295_m / 2 - (this.elementByPage / 2 + 2) * 21, Color.ORANGE.getRGB());
        for (int i = this.page * this.elementByPage; i < this.cursorButtons.size() && i < (this.page + 1) * this.elementByPage; ++i) {
            GuiValueButton<CursorType> button = this.cursorButtons.get(i);
            this.drawCursor(button.field_146128_h + button.field_146120_f + 1, button.field_146129_i, this.cursors.get(button.getValue()));
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73866_w_() {
        this.page = 0;
        this.elementByPage = (this.field_146295_m - 42) / 21;
        if (this.elementByPage > 10) {
            this.elementByPage = 10;
        }
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 79, this.field_146295_m / 2 + this.elementByPage / 2 * 21, 158, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        if (this.elementByPage >= this.cursors.size()) {
            this.lastPage = new GuiButton(1, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + this.elementByPage / 2 * 21, 20, 20, "<");
            this.field_146292_n.add(this.lastPage);
            this.nextPage = new GuiButton(2, this.field_146294_l / 2 + 80, this.field_146295_m / 2 + this.elementByPage / 2 * 21, 20, 20, ">");
            this.field_146292_n.add(this.nextPage);
        } else {
            this.nextPage = null;
            this.lastPage = null;
        }
        int i = -1;
        this.cursorButtons.clear();
        for (CursorType type : this.cursors.keySet()) {
            this.cursorButtons.add(new GuiValueButton<CursorType>(3, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + (i++ % this.elementByPage - this.elementByPage / 2) * 21, 200, 20, type.getName(), type));
        }
        this.field_146292_n.addAll(this.cursorButtons);
        this.defineButton();
        super.func_73866_w_();
    }

    private static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        float f4 = 1.0f / tileWidth;
        float f5 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), 0.0, (double)(u * f4), (double)((v + (float)vHeight) * f5));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)((u + (float)uWidth) * f4), (double)((v + (float)vHeight) * f5));
        tessellator.func_78374_a((double)(x + width), (double)y, 0.0, (double)((u + (float)uWidth) * f4), (double)(v * f5));
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)(u * f4), (double)(v * f5));
        tessellator.func_78381_a();
    }
}

