/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.atesab.customcursormod.CursorClick;
import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorType;
import fr.atesab.customcursormod.gui.GuiSelectZone;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

@Mod(modid="customcursormod", name="Custom Cursor Mod", version="1.2.1", guiFactory="fr.atesab.customcursormod.gui.GuiFactoryCursorMod", acceptedMinecraftVersions="[1.8.9]")
public class CursorMod {
    public static final String MOD_ID = "customcursormod";
    public static final String MOD_NAME = "Custom Cursor Mod";
    public static final String MOD_VERSION = "1.2.1";
    public static final String MOD_GUI_FACTORY = "fr.atesab.customcursormod.gui.GuiFactoryCursorMod";
    public static final Logger logger = Logger.getLogger("Custom Cursor Mod");
    private static final Gson gson = new GsonBuilder().create();
    private static boolean FmlPostInitiated = false;
    private static boolean forceNextCursor = false;
    private static CursorType currentCursorType;
    private static Map<CursorType, CursorConfig> cursors;
    private static List<CursorClick> cursorClicks;
    private static Configuration config;

    private static void changeCursor(CursorType cursor) {
        CursorMod.changeCursor(cursor, forceNextCursor);
        forceNextCursor = false;
    }

    private static void changeCursor(CursorType cursor, boolean forceChange) {
        if (cursor.equals(currentCursorType) && !forceChange) {
            return;
        }
        currentCursorType = cursor;
        try {
            CursorConfig cursorConfig = cursors.getOrDefault(cursor, cursor.getDefaultConfig());
            BufferedImage image = ImageIO.read(cursorConfig.getResource().func_110527_b());
            int w = image.getWidth();
            int h = image.getHeight();
            int numImg = image.getHeight() / image.getWidth();
            int[] pixels = new int[w * h];
            image.getRGB(0, 0, w, h, pixels, 0, w);
            IntBuffer buffer = BufferUtils.createIntBuffer((int)(w * h));
            IntBuffer delayBuffer = BufferUtils.createIntBuffer((int)(numImg * 2));
            for (int i = 0; i < numImg; ++i) {
                delayBuffer.put(cursor.getAnimationDelays());
                for (int y = i * w; y < (i + 1) * w; ++y) {
                    for (int x = 0; x < w; ++x) {
                        buffer.put(pixels[((i + 1) * w - 1 - y) * w + x]);
                    }
                }
            }
            buffer.flip();
            Mouse.setNativeCursor((Cursor)new Cursor(w, w, cursorConfig.getxHotSpot(), w - 1 - cursorConfig.getyHotSpot(), numImg, buffer, numImg != 1 ? delayBuffer : null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void forceNextCursor() {
        forceNextCursor = true;
    }

    public static Map<CursorType, CursorConfig> getCursors() {
        return cursors;
    }

    public static void registerCursor(CursorType ... cursorTypes) {
        if (!FmlPostInitiated) {
            for (CursorType cursorType : cursorTypes) {
                cursors.put(cursorType, cursorType.getDefaultConfig());
            }
        } else {
            logger.log(Level.SEVERE, "Can't register new CursorType after FML Post Initialization.");
        }
    }

    public static void saveConfig() {
        for (CursorType type : cursors.keySet()) {
            String s = gson.toJson((Object)cursors.getOrDefault(type, cursors.get(CursorType.POINTER)));
            config.get("cursors", type.getConfigName(), s).set(s);
        }
        CursorMod.changeCursor(currentCursorType, true);
        config.save();
    }

    public static void setCursors(Map<CursorType, CursorConfig> cursors) {
        CursorMod.cursors = cursors;
    }

    public static void syncConfig() {
        for (CursorType type : cursors.keySet()) {
            try {
                cursors.put(type, (CursorConfig)gson.fromJson(config.getString(type.getConfigName(), "cursors", gson.toJson((Object)cursors.getOrDefault(type, cursors.get(CursorType.POINTER))), ""), CursorConfig.class));
            }
            catch (Exception e) {
                logger.warning("Can't load the cursor \"" + type.getConfigName() + "\" : " + e.getMessage());
            }
        }
        CursorMod.changeCursor(currentCursorType, true);
        config.save();
    }

    private List<Field[]> getDeclaredField(Class<?> cls) {
        ArrayList<Field[]> l = new ArrayList<Field[]>();
        l.add(cls.getDeclaredFields());
        while (!cls.equals(Object.class)) {
            cls = cls.getSuperclass();
            l.add(cls.getDeclaredFields());
        }
        return l;
    }

    private boolean isHover(int mouseX, int mouseY, int x, int y, int width, int height) {
        x = Math.min(x + width, x);
        y = Math.min(y + height, y);
        width = Math.abs(width);
        height = Math.abs(height);
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private boolean isHoverButton(int mouseX, int mouseY, GuiButton button) {
        return button != null && button.field_146125_m && button.field_146124_l && this.isHover(mouseX, mouseY, button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g);
    }

    private boolean isHoverTextField(int mouseX, int mouseY, GuiTextField textField) {
        return textField != null && textField.func_146176_q() && this.isHover(mouseX, mouseY, textField.field_146209_f, textField.field_146210_g, textField.field_146218_h, textField.field_146219_i);
    }

    @Mod.EventHandler
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent ev) {
        if (ev.modID.equals(MOD_ID)) {
            CursorMod.syncConfig();
        }
    }

    @SubscribeEvent
    public void onInitScreen(GuiScreenEvent.InitGuiEvent ev) {
        CursorMod.forceNextCursor();
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent ev) {
        IChatComponent ichatcomponent;
        GuiScreen gui = ev.gui;
        CursorType newCursorType = CursorType.POINTER;
        for (Field[] fa : this.getDeclaredField(gui.getClass())) {
            block3: for (Field f : fa) {
                try {
                    f.setAccessible(true);
                    Object o = f.get(gui);
                    if (o == null) continue;
                    if (o instanceof GuiTextField) {
                        if (!this.isHoverTextField(ev.mouseX, ev.mouseY, (GuiTextField)o)) continue;
                        newCursorType = CursorType.BEAM;
                        continue;
                    }
                    if (o instanceof GuiButton) {
                        if (!this.isHoverButton(ev.mouseX, ev.mouseY, (GuiButton)o)) continue;
                        newCursorType = CursorType.HAND;
                        continue;
                    }
                    if (o instanceof GuiSelectZone) {
                        GuiSelectZone selectZone = (GuiSelectZone)o;
                        if (!this.isHover(ev.mouseX, ev.mouseY, selectZone.xPosition, selectZone.yPosition, selectZone.width, selectZone.height) || !selectZone.enable) continue;
                        newCursorType = CursorType.CROSS;
                        continue;
                    }
                    if (!(o instanceof List)) continue;
                    for (Object e : (List)o) {
                        if (e instanceof GuiButton) {
                            if (!this.isHoverButton(ev.mouseX, ev.mouseY, (GuiButton)e)) continue;
                            newCursorType = CursorType.HAND;
                            continue;
                        }
                        if (e instanceof GuiTextField) {
                            if (!this.isHoverTextField(ev.mouseX, ev.mouseY, (GuiTextField)e)) continue;
                            newCursorType = CursorType.BEAM;
                            continue;
                        }
                        if (!(e instanceof GuiSelectZone)) continue block3;
                        GuiSelectZone selectZone = (GuiSelectZone)e;
                        if (!this.isHover(ev.mouseX, ev.mouseY, selectZone.xPosition, selectZone.yPosition, selectZone.width, selectZone.height) || !selectZone.enable) continue;
                        newCursorType = CursorType.CROSS;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (gui instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)gui;
            if (gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o() != null) {
                newCursorType = CursorType.HAND_GRAB;
            } else if (container.getSlotUnderMouse() != null && container.getSlotUnderMouse().func_75216_d()) {
                newCursorType = CursorType.HAND;
            }
        } else if (gui instanceof GuiChat && (ichatcomponent = gui.field_146297_k.field_71456_v.func_146158_b().func_146236_a(Mouse.getX(), Mouse.getY())) != null && ichatcomponent.func_150256_b().func_150235_h() != null) {
            newCursorType = CursorType.HAND;
        }
        for (CursorType cursorType : cursors.keySet()) {
            if (cursorType.getCursorTester() == null || !cursorType.getCursorTester().testCursor(newCursorType, gui, ev.mouseX, ev.mouseY, ev.renderPartialTicks)) continue;
            newCursorType = cursorType;
            break;
        }
        CursorMod.changeCursor(newCursorType);
        Iterator<CursorClick> iterator = cursorClicks.iterator();
        while (iterator.hasNext()) {
            CursorClick cursorClick = iterator.next();
            int posX = (int)((double)gui.field_146294_l * cursorClick.getPosX());
            int posY = gui.field_146295_m - (int)((double)gui.field_146295_m * cursorClick.getPosY());
            gui.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/click_" + (2 - cursorClick.getTime() / 4) + ".png"));
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GuiScreen cfr_ignored_0 = ev.gui;
            GuiScreen.func_152125_a((int)(posX - 8), (int)(posY - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16, (float)16.0f, (float)16.0f);
            cursorClick.descreaseTime();
            if (cursorClick.getTime() > 0) continue;
            iterator.remove();
        }
    }

    @SubscribeEvent
    public void onGuiCloses(TickEvent ev) {
        if (cursorClicks.size() != 0 && Minecraft.func_71410_x().field_71462_r == null) {
            cursorClicks.clear();
        }
    }

    @SubscribeEvent
    public void onMouseInput(GuiScreenEvent.MouseInputEvent ev) {
        if (Mouse.isButtonDown((int)0)) {
            ScaledResolution scaledResolution = new ScaledResolution(ev.gui.field_146297_k);
            cursorClicks.add(new CursorClick(11, (double)(Mouse.getX() / scaledResolution.func_78325_e()) / scaledResolution.func_78327_c(), (double)(Mouse.getY() / scaledResolution.func_78325_e()) / scaledResolution.func_78324_d()));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent ev) {
        FmlPostInitiated = true;
        config.load();
        CursorMod.syncConfig();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        currentCursorType = CursorType.POINTER;
        CursorMod.registerCursor(currentCursorType, CursorType.HAND, CursorType.HAND_GRAB, CursorType.BEAM, CursorType.CROSS);
        config = new Configuration(ev.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    static {
        cursors = new HashMap<CursorType, CursorConfig>();
        cursorClicks = new ArrayList<CursorClick>();
    }
}

