/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.common;

import com.mia.craftstudio.libgdx.Vector3;
import com.mia.craftstudio.minecraft.BlockDimensionalPosition;
import com.mia.craftstudio.minecraft.IAnimatedTile;
import com.mia.props.DecoModelMetadata;
import com.mia.props.Props;
import com.mia.props.common.TileFake;
import com.mia.props.network.Msg0x00SwitchRunning;
import com.mia.props.network.NetworkHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileProps
extends TileEntity
implements IAnimatedTile {
    public int type = 0;
    public int rotation;
    protected boolean isRunning = false;
    public Random rand = new Random();
    public Set<Integer[]> slaves = new HashSet<Integer[]>();
    public Map<String, String> tileParams = new HashMap<String, String>();
    protected boolean initialized = false;
    private BlockDimensionalPosition dimpos = null;

    public void init() {
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Override
    public BlockDimensionalPosition getBlockPosDim() {
        if (this.dimpos == null) {
            this.dimpos = new BlockDimensionalPosition(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.dimpos;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.dimpos = null;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.dimpos = null;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.dimpos = null;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.type = compound.func_74762_e("BlockType");
        this.rotation = compound.func_74762_e("BlockRotation");
        boolean bl = this.isRunning = compound.func_74764_b("isRunning") ? compound.func_74767_n("isRunning") : false;
        if (this.field_145850_b != null) {
            TileProps tileProps = this.getNewTileEntityForMeta(this.type, this.rotation, this.isRunning);
            NBTTagList slaves = compound.func_150295_c("slaves", 11);
            for (int i = 0; i < slaves.func_74745_c(); ++i) {
                int[] pos = slaves.func_150306_c(i);
                tileProps.slaves.add(new Integer[]{pos[0], pos[1], pos[2]});
            }
            this.field_145850_b.func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)tileProps);
            tileProps.init();
        } else {
            NBTTagList slaves = compound.func_150295_c("slaves", 11);
            for (int i = 0; i < slaves.func_74745_c(); ++i) {
                int[] pos = slaves.func_150306_c(i);
                this.slaves.add(new Integer[]{pos[0], pos[1], pos[2]});
            }
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("BlockType", this.type);
        compound.func_74768_a("BlockRotation", this.rotation);
        compound.func_74757_a("isRunning", this.isRunning);
        NBTTagList slavesLst = new NBTTagList();
        for (Integer[] slave : this.slaves) {
            NBTTagIntArray pos = new NBTTagIntArray(new int[]{slave[0], slave[1], slave[2]});
            slavesLst.func_74742_a((NBTBase)pos);
        }
        compound.func_74782_a("slaves", (NBTBase)slavesLst);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public TileProps getNewTileEntityForMeta(int meta, int rotation, boolean isRunning) {
        try {
            TileProps tile = Props.modelData.get((Object)Integer.valueOf((int)meta)).tileType.getTileClass().newInstance();
            tile.type = meta;
            tile.rotation = rotation;
            tile.isRunning = isRunning;
            tile.tileParams = Props.modelData.get((Object)Integer.valueOf((int)meta)).tileParams;
            return tile;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.printf("!!! CRITICAL ERROR : PRB WHILE LOADING TE FOR META %s !!!\n", meta);
            throw new RuntimeException(e);
        }
        return null;
    }

    public void renderParticles(World world, int x, int y, int z, Random random) {
    }

    public boolean canUpdate() {
        return false;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float var7, float var8, float var9) {
        return false;
    }

    public int getMetadata() {
        return this.rotation;
    }

    public void switchIsRunning() {
        boolean bl = this.isRunning = !this.isRunning;
        if (!this.field_145850_b.field_72995_K) {
            NetworkHelper.INSTANCE.network.sendToDimension((IMessage)new Msg0x00SwitchRunning(this), this.field_145850_b.field_73011_w.field_76574_g);
        }
    }

    public void setIsRunning(boolean state) {
        this.isRunning = state;
        if (!this.field_145850_b.field_72995_K) {
            NetworkHelper.INSTANCE.network.sendToDimension((IMessage)new Msg0x00SwitchRunning(this), this.field_145850_b.field_73011_w.field_76574_g);
        }
    }

    public boolean getIsRunning() {
        return this.isRunning;
    }

    public boolean isBed() {
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (this.getModelData() != null) {
            return this.getModelData().lightLevel;
        }
        return 0;
    }

    public int getSizeInventoryX() {
        return this.getModelData().invX;
    }

    public int getSizeInventoryY() {
        return this.getModelData().invY;
    }

    public void onBlockHarvested(World world, int x, int y, int z, int par5, EntityPlayer par6EntityPlayer) {
    }

    public boolean onItemStackDropSaveNBT() {
        return false;
    }

    public void addSlave(TileFake slave) {
        this.slaves.add(new Integer[]{slave.field_145851_c, slave.field_145848_d, slave.field_145849_e});
    }

    public void rmSlave(TileFake slave) {
        this.slaves.remove(new Integer[]{slave.field_145851_c, slave.field_145848_d, slave.field_145849_e});
        this.field_145850_b.func_147468_f(slave.field_145851_c, slave.field_145848_d, slave.field_145849_e);
    }

    public void removeSlaves() {
        for (Integer[] slave : this.slaves) {
            this.field_145850_b.func_147468_f(slave[0].intValue(), slave[1].intValue(), slave[2].intValue());
        }
    }

    public DecoModelMetadata getModelData() {
        return Props.modelData.get(this.type);
    }

    public void markRenderDirty() {
    }

    public boolean sameID(TileEntity tile) {
        if (!(tile instanceof TileProps)) {
            return false;
        }
        return this.getModelData().decocraftModelID == ((TileProps)tile).getModelData().decocraftModelID;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        Vector3[] bounds = Props.modelData.get((Object)Integer.valueOf((int)this.type)).wrapper.getExtend(this.rotation);
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + (double)bounds[0].x), (double)((double)this.field_145848_d + (double)bounds[0].y), (double)((double)this.field_145849_e + (double)bounds[0].z), (double)((double)this.field_145851_c + (double)bounds[1].x), (double)((double)this.field_145848_d + (double)bounds[1].y), (double)((double)this.field_145849_e + (double)bounds[1].z));
    }

    public int getRenderingType() {
        return this.type;
    }
}

