/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.libgdx.Vector3;
import com.mia.props.DecoModelMetadata;
import com.mia.props.Props;
import com.mia.props.common.TileProps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockProps
extends BlockContainer {
    private static final Cache<Object, TimedBool> eggedEntities = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(2500L, TimeUnit.MILLISECONDS).build();

    public BlockProps() {
        super(Material.field_151580_n);
        this.func_149711_c(0.25f);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile;
        ItemStack stack = super.getPickBlock(target, world, pos, player);
        if (player.func_70093_af() && (tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos)) instanceof TileProps && ((TileProps)tile).onItemStackDropSaveNBT()) {
            NBTTagCompound tag = new NBTTagCompound();
            tile.func_145841_b(tag);
            tag.func_82580_o("slaves");
            stack.func_77983_a("savedProp", (NBTBase)tag);
        }
        return stack;
    }

    public void func_180654_a(IBlockAccess par1IBlockAccess, BlockPos pos) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(par1IBlockAccess, pos);
        if (tile instanceof TileProps) {
            Vector3[] bounds = Props.modelData.get((Object)Integer.valueOf((int)((TileProps)tile).type)).wrapper.getExtend(((TileProps)tile).rotation);
            this.func_149676_a(bounds[0].x, bounds[0].y, bounds[0].z, bounds[1].x, bounds[1].y, bounds[1].z);
        }
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity ent) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            DecoModelMetadata data = Props.modelData.get(((TileProps)tile).type);
            if (data.walkthrough) {
                return;
            }
            CSModel model = data.csmodel;
            for (CSModel.ModelNode node : model.getNodes()) {
                if (node.hasAttribute(CSModel.ModelNode.Attrb.PASSABLE) || node.hasAttribute(CSModel.ModelNode.Attrb.PASSABLEPROPAGATES)) continue;
                Vector3[] extend = data.wrapper.nodeCache.get(node).getExtend(((TileProps)tile).rotation);
                AxisAlignedBB aabb = AxisAlignedBB.func_178781_a((double)extend[0].x, (double)extend[0].y, (double)extend[0].z, (double)extend[1].x, (double)extend[1].y, (double)extend[1].z);
                AxisAlignedBB aabbTmp = aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                if (!mask.func_72326_a(aabbTmp)) continue;
                list.add(aabbTmp);
            }
        } else {
            super.func_180638_a(world, pos, state, mask, list, ent);
        }
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)worldIn, pos);
        if (tile instanceof TileProps) {
            DecoModelMetadata data = Props.modelData.get(((TileProps)tile).type);
            if (data.walkthrough) {
                return null;
            }
            CSModel model = data.csmodel;
            AxisAlignedBB ret = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            for (CSModel.ModelNode node : model.getNodes()) {
                if (node.hasAttribute(CSModel.ModelNode.Attrb.PASSABLE) || node.hasAttribute(CSModel.ModelNode.Attrb.PASSABLEPROPAGATES)) continue;
                Vector3[] extend = data.wrapper.nodeCache.get(node).getExtend(((TileProps)tile).rotation);
                AxisAlignedBB aabb = AxisAlignedBB.func_178781_a((double)extend[0].x, (double)extend[0].y, (double)extend[0].z, (double)extend[1].x, (double)extend[1].y, (double)extend[1].z);
                AxisAlignedBB aabbTmp = aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                ret.func_111270_a(aabbTmp);
            }
            return ret;
        }
        return super.func_180640_a(worldIn, pos, state);
    }

    public MovingObjectPosition func_180636_a(World world, BlockPos pos, Vec3 origin, Vec3 direction) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            DecoModelMetadata data = Props.modelData.get(((TileProps)tile).type);
            MovingObjectPosition closest = null;
            CSModel model = data.csmodel;
            for (CSModel.ModelNode node : model.getNodes()) {
                Vector3[] extend = data.wrapper.nodeCache.get(node).getExtend(((TileProps)tile).rotation);
                AxisAlignedBB aabb = AxisAlignedBB.func_178781_a((double)extend[0].x, (double)extend[0].y, (double)extend[0].z, (double)extend[1].x, (double)extend[1].y, (double)extend[1].z);
                MovingObjectPosition mop = aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72327_a(origin, direction);
                if (mop == null) continue;
                if (closest != null && mop.field_72307_f.func_72438_d(origin) < closest.field_72307_f.func_72438_d(origin)) {
                    closest = mop;
                    continue;
                }
                closest = mop;
            }
            if (closest != null) {
                closest = new MovingObjectPosition(closest.field_72307_f, closest.field_178784_b, pos);
            }
            return closest;
        }
        return super.func_180636_a(world, pos, origin, direction);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public TileEntity func_149915_a(World world, int meta) {
        try {
            return Props.modelData.get((Object)Integer.valueOf((int)meta)).tileType.getTileClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.printf("!!! CRITICAL ERROR : PRB WHILE LOADING TE FOR META %s !!!\n", meta);
            throw new RuntimeException(e);
        }
        return new TileProps();
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_180665_b(World par1World, BlockPos pos) {
        return Props.itemProps;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(world, pos);
        if (tile instanceof TileProps) {
            return ((TileProps)tile).getLightValue(world, pos);
        }
        return 0;
    }

    public int func_176222_j(World world, BlockPos pos) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            return ((TileProps)tile).type;
        }
        return 0;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer par6EntityPlayer) {
        NBTTagCompound savedNBT = null;
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            if (((TileProps)tile).onItemStackDropSaveNBT()) {
                savedNBT = new NBTTagCompound();
                tile.func_145841_b(savedNBT);
                savedNBT.func_82580_o("slaves");
            }
            ((TileProps)tile).onBlockHarvested(world, pos, state, par6EntityPlayer);
        }
        if (!par6EntityPlayer.field_71075_bZ.field_75098_d) {
            ItemStack droppedItem = new ItemStack(Props.itemProps, 1, this.func_176222_j(world, pos));
            if (savedNBT != null) {
                droppedItem.func_77983_a("savedProp", (NBTBase)savedNBT);
            }
            BlockProps.func_180635_a((World)world, (BlockPos)pos, (ItemStack)droppedItem);
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            ((TileProps)tile).onBlockClicked(world, pos, player);
        }
    }

    private void playBlockSound(World world, TileProps prop, Entity player) {
        String sfx;
        if (world.field_72995_K) {
            return;
        }
        if (prop != null && (sfx = Props.modelData.get((Object)Integer.valueOf((int)prop.type)).sound) != null) {
            world.func_72956_a(player, "props:" + sfx, 1.0f, 1.0f);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            this.playBlockSound(world, (TileProps)tile, (Entity)player);
            return ((TileProps)tile).onBlockActivated(world, pos, state, player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            ((TileProps)tile).renderParticles(world, pos, state, rand);
        }
    }

    public boolean isBed(IBlockAccess world, BlockPos pos, Entity player) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(world, pos);
        if (tile instanceof TileProps) {
            return ((TileProps)tile).isBed();
        }
        return false;
    }

    public EnumFacing getBedDirection(IBlockAccess world, BlockPos pos) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(world, pos);
        if (tile instanceof TileProps && ((TileProps)tile).isBed()) {
            return EnumFacing.values()[((TileProps)tile).rotation / 4];
        }
        return super.getBedDirection(world, pos);
    }

    public boolean isBedFoot(IBlockAccess world, BlockPos pos) {
        return super.isBedFoot(world, pos);
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(world, pos);
        if (tile instanceof TileProps) {
            ((TileProps)tile).setBedOccupied(world, pos, player, occupied);
        }
    }

    public BlockPos getBedSpawnPosition(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(world, pos);
        if (tile instanceof TileProps) {
            return ((TileProps)tile).getBedSpawnPosition(world, pos, player);
        }
        return pos;
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity master = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (master instanceof TileProps) {
            ((TileProps)master).removeSlaves();
        }
        world.func_175698_g(pos);
        return true;
    }

    private static void eggCacheAndSpawnEntity(Entity newSpawn, World world, double x, double y, double z) {
        newSpawn.func_70012_b(x + (double)((world.field_73012_v.nextFloat() - 0.5f) / 4.0f), y + (double)((world.field_73012_v.nextFloat() - 0.5f) / 4.0f), z + (double)((world.field_73012_v.nextFloat() - 0.5f) / 4.0f), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        newSpawn.func_70110_aj();
        world.func_72838_d(newSpawn);
        eggedEntities.put((Object)newSpawn, (Object)new TimedBool(false, System.currentTimeMillis()));
    }

    static void onEntityWebbed(Entity webbedEntity, World world) {
        webbedEntity.func_70110_aj();
        if (world.field_72995_K || webbedEntity.field_70128_L) {
            return;
        }
        TimedBool egged = (TimedBool)eggedEntities.getIfPresent((Object)webbedEntity);
        if (egged == null || !egged.value && egged.time + 500L <= System.currentTimeMillis()) {
            if (egged == null) {
                egged = new TimedBool(true, System.currentTimeMillis());
            }
            egged.value = true;
            eggedEntities.put((Object)webbedEntity, (Object)egged);
            if (webbedEntity instanceof EntitySpider) {
                if ((double)world.field_73012_v.nextFloat() <= 0.3) {
                    Constructor<?>[] ctors = webbedEntity.getClass().getDeclaredConstructors();
                    Constructor<?> ctor = null;
                    for (int i = 0; i < ctors.length; ++i) {
                        if (ctors[i].getParameterTypes().length != 1 || !ctors[i].getParameterTypes()[0].isAssignableFrom(World.class)) continue;
                        ctor = ctors[i];
                        break;
                    }
                    if (ctor != null) {
                        try {
                            BlockProps.eggCacheAndSpawnEntity((Entity)ctor.newInstance(world), world, webbedEntity.field_70165_t, webbedEntity.field_70163_u, webbedEntity.field_70161_v);
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                    }
                }
            } else if (webbedEntity instanceof EntityPlayer && (double)world.field_73012_v.nextFloat() <= 0.5) {
                BlockProps.eggCacheAndSpawnEntity((Entity)new EntitySpider(world), world, webbedEntity.field_70165_t, webbedEntity.field_70163_u, webbedEntity.field_70161_v);
            }
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity collidingEntity) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps && ((TileProps)tile).getModelData().spiderweb) {
            BlockProps.onEntityWebbed(collidingEntity, world);
        }
    }

    private static class TimedBool {
        public boolean value;
        public long time;

        public TimedBool(boolean v, long t) {
            this.value = v;
            this.time = t;
        }
    }
}

