/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.common.entities;

import com.mia.props.DecoModelMetadata;
import com.mia.props.Props;
import com.mia.props.common.entities.TileContainer;
import com.mia.props.network.Msg0x01SelectDeco;
import com.mia.props.network.NetworkHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;

public class TileDecobench
extends TileContainer
implements ISidedInventory {
    public final int[] MAX_STORE = new int[]{6000, 2000, 2000, 2000};
    private int[] resources = new int[4];

    public TileDecobench() {
        this.slots = new ItemStack[2];
    }

    public int getResource(int idx) {
        return this.resources[idx];
    }

    public int[] getResources() {
        return this.resources;
    }

    public void setResource(int idx, int amount) {
        this.resources[idx] = amount;
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("clay", this.resources[0]);
        tagCompound.func_74768_a("red", this.resources[1]);
        tagCompound.func_74768_a("blue", this.resources[2]);
        tagCompound.func_74768_a("green", this.resources[3]);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.resources[0] = tagCompound.func_74762_e("clay");
        this.resources[1] = tagCompound.func_74762_e("red");
        this.resources[2] = tagCompound.func_74762_e("blue");
        this.resources[3] = tagCompound.func_74762_e("green");
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)Props.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public String func_70005_c_() {
        return "decocraft.decobench";
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        this.slots[slot] = stack;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 1 && super.func_94041_b(slot, stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int slot, ItemStack itemStackIn, EnumFacing direction) {
        return slot == 0;
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return slot == 1;
    }

    @Override
    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer par6EntityPlayer) {
    }

    @Override
    public boolean onItemStackDropSaveNBT() {
        return true;
    }

    public static int[] resourcesProvidedByStack(ItemStack stack) {
        int[] resources = new int[4];
        for (ItemStack allowedStack : Props.allowableResourceItems) {
            if (!OreDictionary.itemMatches((ItemStack)allowedStack, (ItemStack)stack, (boolean)false)) continue;
            if (stack.func_77973_b().equals(Props.itemClay)) {
                resources[0] = 2;
                if (stack.func_77952_i() == 2) {
                    resources[2] = 2;
                    break;
                }
                if (stack.func_77952_i() == 1) {
                    resources[3] = 2;
                    break;
                }
                resources[1] = 2;
                break;
            }
            if (stack.func_77973_b().equals(Props.itemProps)) {
                if (!Props.allowPropRecycling) break;
                DecoModelMetadata meta = Props.modelData.get(stack.func_77952_i());
                for (int i = 0; i < 4; ++i) {
                    resources[i] = meta.resourceCost[i];
                }
            } else {
                int[] oreIds;
                if (stack.func_77973_b().equals(Items.field_151119_aD)) {
                    resources[0] = 2;
                    break;
                }
                if (stack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150435_aG))) {
                    resources[0] = 8;
                    break;
                }
                for (int id : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
                    try {
                        int[] dyeResources = DyeResourceMap.valueOf((String)OreDictionary.getOreName((int)id)).resources;
                        resources[1] = dyeResources[0];
                        resources[2] = dyeResources[1];
                        resources[3] = dyeResources[2];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            break;
        }
        int i = 0;
        while (i < 4) {
            int n = i++;
            resources[n] = resources[n] * stack.field_77994_a;
        }
        return resources;
    }

    public boolean roomForResources(int[] resourcesToAdd) {
        return resourcesToAdd[0] + this.resources[0] <= this.MAX_STORE[0] && resourcesToAdd[1] + this.resources[1] <= this.MAX_STORE[1] && resourcesToAdd[2] + this.resources[2] <= this.MAX_STORE[2] && resourcesToAdd[3] + this.resources[3] <= this.MAX_STORE[3];
    }

    public void onData(EntityPlayer player, int decoID, boolean shiftkeyDown) {
        if (this.field_145850_b.field_72995_K) {
            NetworkHelper.INSTANCE.network.sendToServer((IMessage)new Msg0x01SelectDeco(this, decoID, shiftkeyDown));
            return;
        }
        boolean isDirty = false;
        if (decoID < 0) {
            if (decoID == -1 && this.slots[0] != null) {
                int[] resourcesProvided = TileDecobench.resourcesProvidedByStack(this.slots[0]);
                if (shiftkeyDown || this.roomForResources(resourcesProvided)) {
                    for (int i = 0; i < 4; ++i) {
                        int n = i;
                        this.resources[n] = this.resources[n] + resourcesProvided[i];
                        if (this.resources[i] <= this.MAX_STORE[i]) continue;
                        this.resources[i] = this.MAX_STORE[i];
                    }
                    this.slots[0] = null;
                    isDirty = true;
                }
            }
        } else {
            DecoModelMetadata modelmeta = Props.modelData.get(decoID);
            while ((this.slots[1] == null ? Props.itemProps.func_77639_j() : this.slots[1].func_77976_d() - this.slots[1].field_77994_a) > 0 && modelmeta.isCraftable(this.resources)) {
                ItemStack stack = new ItemStack(Props.itemProps, 1, decoID);
                if (this.slots[1] == null || this.slots[1].func_77969_a(stack) && this.slots[1].field_77994_a < this.slots[1].func_77976_d()) {
                    if (this.slots[1] == null) {
                        this.slots[1] = stack.func_77946_l();
                    } else {
                        ++this.slots[1].field_77994_a;
                    }
                    for (int r = 0; r < 4; ++r) {
                        int n = r;
                        this.resources[n] = this.resources[n] - modelmeta.resourceCost[r];
                    }
                    isDirty = true;
                }
                if (shiftkeyDown) continue;
            }
            if (isDirty) {
                this.func_70296_d();
            }
        }
    }

    public static enum DyeResourceMap {
        dyeRed(8, 0, 0),
        dyeGreen(0, 8, 0),
        dyeBlue(0, 0, 8),
        dyePurple(4, 0, 4),
        dyeCyan(0, 4, 4),
        dyeYellow(4, 4, 0);

        int[] resources = new int[3];

        private DyeResourceMap(int r, int g, int b) {
            this.resources[0] = r;
            this.resources[1] = g;
            this.resources[2] = b;
        }
    }
}

