/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.common.entities;

import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.libgdx.Vector3;
import com.mia.craftstudio.minecraft.CraftStudioModelWrapper;
import com.mia.props.client.fx.ParticleHandler;
import com.mia.props.common.TileProps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;

public class TileParticleEmitter
extends TileProps
implements ITickable {
    List<ParticleEmitter> emittersOnRender;
    List<ParticleEmitter> emittersOnUpdate;

    @Override
    public void renderParticles(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.emittersOnRender == null) {
            this.generateEmitters();
        }
        this.renderParts(world, this.emittersOnRender);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.emittersOnUpdate == null) {
                this.generateEmitters();
            }
            this.renderParts(this.field_145850_b, this.emittersOnUpdate);
        }
    }

    protected void renderParts(World world, List<ParticleEmitter> emitters) {
        if (emitters == null) {
            return;
        }
        for (ParticleEmitter pe : emitters) {
            if (pe.speed == 1) {
                ParticleHandler.INSTANCE.renderParticle(pe.type, world, pe.x, pe.y, pe.z, 0.0, 0.0, 0.0, pe.size);
                continue;
            }
            for (int i = 0; i < this.rand.nextInt(pe.speed) + pe.speed / 2; ++i) {
                ParticleHandler.INSTANCE.renderParticle(pe.type, world, pe.x, pe.y, pe.z, 0.0, 0.0, 0.0, pe.size);
            }
        }
    }

    protected void generateEmitters() {
        if (this.getModelData().decocraftModelID == 0) {
            return;
        }
        this.emittersOnUpdate = new ArrayList<ParticleEmitter>();
        this.emittersOnRender = new ArrayList<ParticleEmitter>();
        CraftStudioModelWrapper.NodeHashCache nodeCache = this.getModelData().wrapper.nodeCache;
        Collection<CSModel.ModelNode> nodes = this.getModelData().csmodel.getNodes();
        for (CSModel.ModelNode node : nodes) {
            if (!node.getName().startsWith("ParticleEmitter_")) continue;
            String key = node.getName().replace("ParticleEmitter_", "").toLowerCase() + "_";
            String type = "magic";
            float size = 1.0f;
            int speed = 1;
            boolean onupdate = false;
            if (this.tileParams.containsKey(key + "type")) {
                type = (String)this.tileParams.get(key + "type");
            }
            if (this.tileParams.containsKey(key + "size")) {
                size = Float.valueOf((String)this.tileParams.get(key + "size")).floatValue();
            }
            if (this.tileParams.containsKey(key + "speed")) {
                speed = Integer.valueOf((String)this.tileParams.get(key + "speed"));
            }
            if (this.tileParams.containsKey(key + "onUpdate")) {
                onupdate = Boolean.valueOf((String)this.tileParams.get(key + "onUpdate"));
            }
            CraftStudioModelWrapper.NodeWrapper nodeWrapper = nodeCache.get(node);
            BlockPos pos = this.func_174877_v();
            if (onupdate) {
                this.emittersOnUpdate.add(new ParticleEmitter(type, size, speed, onupdate, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), nodeWrapper.getExtend(this.rotation)[0]));
                continue;
            }
            this.emittersOnRender.add(new ParticleEmitter(type, size, speed, onupdate, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), nodeWrapper.getExtend(this.rotation)[0]));
        }
    }

    class ParticleEmitter {
        public final int speed;
        public final String type;
        public final float size;
        public final Vector3 pos;
        public final double x;
        public final double y;
        public final double z;
        public final boolean onUpdate;

        public ParticleEmitter(String type, float size, int speed, boolean onUpdate, int x, int y, int z, Vector3 pos) {
            this.type = type;
            this.speed = speed;
            this.size = size;
            this.onUpdate = onUpdate;
            this.pos = pos;
            this.x = this.pos.x + (float)x;
            this.y = this.pos.y + (float)y;
            this.z = this.pos.z + (float)z;
        }

        public String toString() {
            return String.format("[Particle Emitter : %s %s %s]", this.type, Float.valueOf(this.size), this.pos);
        }
    }
}

