/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.network;

import doggytalents.network.AbstractMessage;
import doggytalents.network.packet.client.CommandMessage;
import doggytalents.network.packet.client.DogFriendlyFireMessage;
import doggytalents.network.packet.client.DogJumpMessage;
import doggytalents.network.packet.client.DogModeMessage;
import doggytalents.network.packet.client.DogNameMessage;
import doggytalents.network.packet.client.DogObeyMessage;
import doggytalents.network.packet.client.DogTalentMessage;
import doggytalents.network.packet.client.DogTextureMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDispatcher {
    private static int packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("DOGGY");

    public static final void registerPackets() {
        PacketDispatcher.registerMessage(CommandMessage.class);
        PacketDispatcher.registerMessage(DogJumpMessage.class);
        PacketDispatcher.registerMessage(DogModeMessage.class);
        PacketDispatcher.registerMessage(DogNameMessage.class);
        PacketDispatcher.registerMessage(DogObeyMessage.class);
        PacketDispatcher.registerMessage(DogTalentMessage.class);
        PacketDispatcher.registerMessage(DogFriendlyFireMessage.class);
        PacketDispatcher.registerMessage(DogTextureMessage.class);
    }

    public static final <T extends AbstractMessage<T>> void registerMessage(Class<T> clazz) {
        if (AbstractMessage.AbstractClientMessage.class.isAssignableFrom(clazz)) {
            dispatcher.registerMessage(clazz, clazz, packetId++, Side.CLIENT);
        } else if (AbstractMessage.AbstractServerMessage.class.isAssignableFrom(clazz)) {
            dispatcher.registerMessage(clazz, clazz, packetId++, Side.SERVER);
        } else {
            dispatcher.registerMessage(clazz, clazz, packetId, Side.CLIENT);
            dispatcher.registerMessage(clazz, clazz, packetId++, Side.SERVER);
        }
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    public static void sendToAll(IMessage message) {
        dispatcher.sendToAll(message);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketDispatcher.sendToAllAround(message, player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToAllAround(IMessage message, TileEntity tileEntity, double range) {
        PacketDispatcher.sendToAllAround(message, tileEntity.func_145831_w().field_73011_w.getDimension(), (double)tileEntity.func_174877_v().func_177958_n() + 0.5, (double)tileEntity.func_174877_v().func_177956_o() + 0.5, (double)tileEntity.func_174877_v().func_177952_p() + 0.5, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }

    public static final Packet getPacket(IMessage message) {
        return dispatcher.getPacketFrom(message);
    }
}

