/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.features;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.feature.ITalentFeature;
import doggytalents.api.inferface.Talent;
import doggytalents.entity.EntityDog;
import doggytalents.entity.features.DogFeature;
import doggytalents.helper.Compatibility;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class TalentFeature
extends DogFeature
implements ITalentFeature {
    public TalentFeature(EntityDog dogIn) {
        super(dogIn);
    }

    @Override
    public void writeAdditional(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        Map<Talent, Integer> map = this.dog.getTalentMap();
        for (Map.Entry<Talent, Integer> entry : map.entrySet()) {
            NBTTagCompound subCompound = new NBTTagCompound();
            subCompound.func_74778_a("talent", entry.getKey().getRegistryName().toString());
            subCompound.func_74768_a("level", entry.getValue().intValue());
            list.func_74742_a((NBTBase)subCompound);
        }
        if (list.func_74745_c() > 0) {
            compound.func_74782_a("talent_level_list", (NBTBase)list);
        }
    }

    @Override
    public void readAdditional(NBTTagCompound compound) {
        String[] split;
        int i;
        HashMap<Talent, Integer> talentMap = new HashMap<Talent, Integer>();
        if (compound.func_150297_b("talent_level_list", 9)) {
            NBTTagList list = compound.func_150295_c("talent_level_list", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound subCompound = list.func_150305_b(i);
                ResourceLocation talentId = new ResourceLocation(subCompound.func_74779_i("talent"));
                int level = subCompound.func_74762_e("level");
                if (!DoggyTalentsAPI.TALENTS.containsKey(talentId)) continue;
                talentMap.put((Talent)DoggyTalentsAPI.TALENTS.getValue(talentId), level);
            }
        } else if (compound.func_150297_b("talents", 8) && (split = compound.func_74779_i("talents").split(":")).length > 0 && split.length % 2 == 0) {
            for (i = 0; i < split.length; i += 2) {
                Talent talent = Compatibility.getTalentOldNamingScheme(split[i]);
                int level = 0;
                try {
                    level = Integer.valueOf(split[i + 1]);
                }
                catch (Exception e) {
                    continue;
                }
                if (talent == null) continue;
                talentMap.put(talent, level);
            }
        }
        if (talentMap.size() > 0) {
            this.dog.setTalentMap(talentMap);
            for (Map.Entry entry : talentMap.entrySet()) {
                ((Talent)((Object)entry.getKey())).onLevelSet(this.dog, (Integer)entry.getValue());
            }
        } else {
            this.dog.setTalentMap(Collections.emptyMap());
        }
    }

    @Override
    public int getLevel(@Nullable Talent talent) {
        Map<Talent, Integer> map = this.dog.getTalentMap();
        return map.containsKey((Object)talent) ? map.get((Object)talent) : 0;
    }

    @Override
    public void setLevel(@Nonnull Talent talent, int level) {
        HashMap<Talent, Integer> map = new HashMap<Talent, Integer>(this.dog.getTalentMap());
        map.put(talent, level);
        talent.onLevelSet(this.dog, level);
        this.dog.setTalentMap(map);
    }

    @Override
    public void resetTalents() {
        this.dog.getTalentMap().forEach((talent, fromLevel) -> talent.onLevelReset(this.dog, (int)fromLevel));
        this.dog.setTalentMap(Collections.emptyMap());
    }
}

