/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.DoggyTalentsMod;
import doggytalents.ModCreativeTabs;
import doggytalents.api.BeddingRegistryEvent;
import doggytalents.block.BlockDogBath;
import doggytalents.block.BlockDogBed;
import doggytalents.block.BlockFoodBowl;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="doggytalents")
public class ModBlocks {
    public static final Block DOG_BED = null;
    public static final Block DOG_BATH = null;
    public static final Block FOOD_BOWL = null;

    @Mod.EventBusSubscriber(modid="doggytalents", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registration {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry blockRegistry = event.getRegistry();
            MinecraftForge.EVENT_BUS.post((Event)new BeddingRegistryEvent());
            DoggyTalentsMod.LOGGER.info("Registering Blocks");
            blockRegistry.register(new BlockDogBed().setRegistryName("doggytalents:dog_bed"));
            blockRegistry.register(new BlockDogBath().setRegistryName("doggytalents:dog_bath"));
            blockRegistry.register(new BlockFoodBowl().setRegistryName("doggytalents:food_bowl"));
            DoggyTalentsMod.LOGGER.info("Finished Registering Blocks");
        }

        @SubscribeEvent
        public static void onItemRegister(RegistryEvent.Register<Item> event) {
            DoggyTalentsMod.LOGGER.info("Registering ItemBlocks");
            event.getRegistry().register((IForgeRegistryEntry)Registration.makeItemBlock(DOG_BED, ModCreativeTabs.DOG_BED));
            event.getRegistry().register((IForgeRegistryEntry)Registration.makeItemBlock(DOG_BATH));
            event.getRegistry().register((IForgeRegistryEntry)Registration.makeItemBlock(FOOD_BOWL));
            DoggyTalentsMod.LOGGER.info("Finished Registering ItemBlocks");
        }

        private static ItemBlock makeItemBlock(Block block) {
            return Registration.makeItemBlock(block, ModCreativeTabs.GENERAL);
        }

        private static ItemBlock makeItemBlock(Block block, ItemGroup group) {
            return (ItemBlock)new ItemBlock(block, new Item.Properties().func_200916_a(group)).setRegistryName(block.getRegistryName());
        }
    }
}

