/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.addon.itemphysic;

import doggytalents.DoggyTalentsMod;
import doggytalents.helper.ReflectionUtil;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class ItemPhysicAPI {
    public Class<?> serverPhysicClass = ReflectionUtil.getClass("com.creativemd.itemphysic.physics.ServerPhysic");
    public Class<?> sortingListClass = ReflectionUtil.getClass("com.creativemd.creativecore.common.utils.type.SortingList");
    public Method addSortingBlock;
    public Method addSortingItem;

    public ItemPhysicAPI() {
        if (this.sortingListClass == null) {
            this.sortingListClass = ReflectionUtil.getClass("com.creativemd.creativecore.common.utils.sorting.SortingList");
        }
        this.addSortingBlock = ReflectionUtil.getMethod(this.sortingListClass, "addSortingByBlock", Block.class);
        this.addSortingItem = ReflectionUtil.getMethod(this.sortingListClass, "addSortingByItem", Item.class);
    }

    public void addSortingBlocks(String sortingListName, Block ... blocks) throws Exception {
        Object sortingList = ReflectionUtil.getField(this.serverPhysicClass, sortingListName).get(null);
        for (Block block : blocks) {
            this.addSortingBlock.invoke(sortingList, block);
            DoggyTalentsMod.LOGGER.info("Successefully registered {} in {} list", (Object)block.getRegistryName(), (Object)sortingListName);
        }
    }

    public void addSortingItems(String sortingListName, Item ... items) throws Exception {
        Object sortingList = ReflectionUtil.getField(this.serverPhysicClass, sortingListName).get(null);
        for (Item item : items) {
            this.addSortingItem.invoke(sortingList, item);
            DoggyTalentsMod.LOGGER.info("Successefully registered {} in {} list", (Object)item.getRegistryName(), (Object)sortingListName);
        }
    }
}

