/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.registry;

import doggytalents.DoggyTalentsMod;
import doggytalents.ModBlocks;
import doggytalents.api.registry.BedMaterial;
import doggytalents.api.registry.CustomIngredient;
import doggytalents.block.PropertyMaterial;
import doggytalents.helper.Compatibility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DogBedRegistry {
    public static final DogBedRegistry CASINGS = new DogBedRegistry("casing");
    public static final DogBedRegistry BEDDINGS = new DogBedRegistry("bedding");
    private final List<BedMaterial> keys = new ArrayList<BedMaterial>();
    private final Map<BedMaterial, String> lookupnames = new HashMap<BedMaterial, String>();
    private final Map<BedMaterial, String> textures = new HashMap<BedMaterial, String>();
    private final Map<BedMaterial, CustomIngredient> craftingItems = new HashMap<BedMaterial, CustomIngredient>();
    private final String key;

    public DogBedRegistry(String key) {
        this.key = key;
    }

    public BedMaterial registerMaterial(@Nonnull String blockId, String textureLocation) {
        ResourceLocation resource = new ResourceLocation(blockId);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resource);
        String lookupname = String.format("dogbed.%s.%s.%s", this.key, resource.func_110624_b(), resource.func_110623_a());
        ItemStack stack = new ItemStack((IItemProvider)block, 1);
        BedMaterial thing = new BedMaterial(blockId);
        return this.registerMaterial(thing, lookupname, textureLocation, stack);
    }

    public BedMaterial registerMaterial(@Nonnull Block block, String textureLocation) {
        ResourceLocation resource = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
        String blockId = resource.func_110624_b() + "_" + resource.func_110623_a();
        String lookupname = String.format("dogbed.%s.%s.%s", this.key, resource.func_110624_b(), resource.func_110623_a());
        ItemStack stack = new ItemStack((IItemProvider)block, 1);
        BedMaterial thing = new BedMaterial(blockId);
        return this.registerMaterial(thing, lookupname, textureLocation, stack);
    }

    public BedMaterial registerMaterial(BedMaterial key, String lookupname, String textureLocation, ItemStack craftingItem) {
        if (this.isValidId(key)) {
            DoggyTalentsMod.LOGGER.warn("Tried to register a dog bed material with the id {} more that once", (Object)key);
            return null;
        }
        this.keys.add(key);
        this.lookupnames.put(key, lookupname);
        this.textures.put(key, textureLocation);
        this.craftingItems.put(key, CustomIngredient.fromStacks(craftingItem));
        DoggyTalentsMod.LOGGER.info("Register dog bed {} under the key {}", (Object)this.key, (Object)key);
        return key;
    }

    public boolean isValidId(BedMaterial id) {
        return this.keys.contains(id);
    }

    public List<BedMaterial> getKeys() {
        return this.keys;
    }

    public BedMaterial getFromString(String key) {
        if (key.equals("missing")) {
            return BedMaterial.NULL;
        }
        key = Compatibility.getBedOldNamingScheme(key);
        for (BedMaterial thing : this.keys) {
            if (!thing.key.equals(key)) continue;
            return thing;
        }
        return BedMaterial.NULL;
    }

    public String getTranslationKey(BedMaterial id) {
        if (!this.isValidId(id)) {
            return "missing";
        }
        return this.lookupnames.get(id);
    }

    private String getTexture(BedMaterial id) {
        if (!this.isValidId(id)) {
            return "missing";
        }
        return this.textures.get(id);
    }

    public String getTexture(IBlockState state, PropertyMaterial property) {
        return this.getTexture((BedMaterial)state.func_177229_b((IProperty)property));
    }

    public String getTexture(NBTTagCompound nbt, String key) {
        return this.getTexture(this.getFromString(nbt.func_74779_i(key)));
    }

    public BedMaterial getIdFromCraftingItem(ItemStack stack) {
        for (Map.Entry<BedMaterial, CustomIngredient> entry : this.craftingItems.entrySet()) {
            if (!entry.getValue().apply(stack)) continue;
            return entry.getKey();
        }
        return BedMaterial.NULL;
    }

    public ItemStack getCraftingItemFromBedMaterial(BedMaterial material) {
        if (this.craftingItems.containsKey(material)) {
            return this.craftingItems.get(material).getIngredient();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack createItemStack(BedMaterial casingId, BedMaterial beddingId) {
        ItemStack stack = new ItemStack((IItemProvider)ModBlocks.DOG_BED, 1);
        stack.func_77982_d(new NBTTagCompound());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("casingId", casingId.key);
        tag.func_74778_a("beddingId", beddingId.key);
        stack.func_77978_p().func_74782_a("doggytalents", (INBTBase)tag);
        return stack;
    }
}

