/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.block;

import doggytalents.ModBeddings;
import doggytalents.api.registry.BedMaterial;
import doggytalents.api.registry.DogBedRegistry;
import doggytalents.block.PropertyMaterial;
import doggytalents.client.model.block.IStateParticleModel;
import doggytalents.client.renderer.particle.ParticleCustomDigging;
import doggytalents.network.PacketHandler;
import doggytalents.network.client.PacketCustomParticle;
import doggytalents.tileentity.TileEntityDogBed;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class BlockDogBed
extends BlockContainer {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    public static final DirectionProperty FACING = BlockHorizontal.field_185512_D;
    public static final PropertyMaterial CASING = PropertyMaterial.create("casing", DogBedRegistry.CASINGS);
    public static final PropertyMaterial BEDDING = PropertyMaterial.create("bedding", DogBedRegistry.BEDDINGS);

    public BlockDogBed() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(3.0f, 5.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)CASING, (Comparable)ModBeddings.OAK)).func_206870_a((IProperty)BEDDING, (Comparable)ModBeddings.WHITE));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("doggytalents")) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("doggytalents");
            BedMaterial casingId = DogBedRegistry.CASINGS.getFromString(tag.func_74779_i("casingId"));
            BedMaterial beddingId = DogBedRegistry.BEDDINGS.getFromString(tag.func_74779_i("beddingId"));
            if (DogBedRegistry.CASINGS.isValidId(casingId)) {
                tooltip.add((ITextComponent)new TextComponentTranslation(DogBedRegistry.CASINGS.getTranslationKey(casingId), new Object[0]));
            } else {
                tooltip.add(new TextComponentTranslation("dogBed.woodError", new Object[0]).func_211708_a(TextFormatting.RED));
            }
            if (DogBedRegistry.BEDDINGS.isValidId(beddingId)) {
                tooltip.add((ITextComponent)new TextComponentTranslation(DogBedRegistry.BEDDINGS.getTranslationKey(beddingId), new Object[0]));
            } else {
                tooltip.add(new TextComponentTranslation("dogBed.woolError", new Object[0]).func_211708_a(TextFormatting.RED));
            }
        }
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        for (BedMaterial beddingId : DogBedRegistry.BEDDINGS.getKeys()) {
            for (BedMaterial casingId : DogBedRegistry.CASINGS.getKeys()) {
                items.add((Object)DogBedRegistry.createItemStack(casingId, beddingId));
            }
        }
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityDogBed();
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return SHAPE;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        state = (IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("doggytalents")) {
            BedMaterial beddingId;
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("doggytalents");
            BedMaterial casingId = DogBedRegistry.CASINGS.getFromString(tag.func_74779_i("casingId"));
            if (DogBedRegistry.CASINGS.isValidId(casingId)) {
                ((TileEntityDogBed)worldIn.func_175625_s(pos)).setCasingId(casingId);
                state = (IBlockState)state.func_206870_a((IProperty)CASING, (Comparable)casingId);
            }
            if (DogBedRegistry.BEDDINGS.isValidId(beddingId = DogBedRegistry.BEDDINGS.getFromString(tag.func_74779_i("beddingId")))) {
                ((TileEntityDogBed)worldIn.func_175625_s(pos)).setBeddingId(beddingId);
                state = (IBlockState)state.func_206870_a((IProperty)BEDDING, (Comparable)beddingId);
            }
        }
        worldIn.func_180501_a(pos, state, 2);
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, CASING, BEDDING});
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_200124_e(IBlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        drops.add((Object)DogBedRegistry.createItemStack((BedMaterial)state.func_177229_b((IProperty)CASING), (BedMaterial)state.func_177229_b((IProperty)BEDDING)));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, EntityPlayer player) {
        return DogBedRegistry.createItemStack((BedMaterial)state.func_177229_b((IProperty)CASING), (BedMaterial)state.func_177229_b((IProperty)BEDDING));
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == EnumFacing.DOWN && !stateIn.func_196955_c((IWorldReaderBase)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        return down.func_185896_q() || down.func_193401_d((IBlockReader)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return (IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(IBlockState state, World world, BlockPos pos, ParticleManager manager) {
        TextureAtlasSprite sprite;
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model instanceof IStateParticleModel && (sprite = ((IStateParticleModel)model).getParticleTexture(state = state.getExtendedState((IBlockReader)world, pos))) != null) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        manager.func_78873_a((Particle)new ParticleCustomDigging(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, state, pos, sprite));
                    }
                }
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model instanceof IStateParticleModel) {
            BlockPos pos = target.func_178782_a();
            EnumFacing side = target.field_178784_b;
            TextureAtlasSprite sprite = ((IStateParticleModel)model).getParticleTexture(state = this.getExtendedState(state.getExtendedState((IBlockReader)world, pos), (IBlockReader)world, pos));
            if (sprite != null) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                AxisAlignedBB axisalignedbb = state.func_196954_c((IBlockReader)world, pos).func_197752_a();
                double d0 = (double)x + this.RANDOM.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
                double d1 = (double)y + this.RANDOM.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
                double d2 = (double)z + this.RANDOM.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
                if (side == EnumFacing.DOWN) {
                    d1 = (double)y + axisalignedbb.field_72338_b - (double)0.1f;
                }
                if (side == EnumFacing.UP) {
                    d1 = (double)y + axisalignedbb.field_72337_e + (double)0.1f;
                }
                if (side == EnumFacing.NORTH) {
                    d2 = (double)z + axisalignedbb.field_72339_c - (double)0.1f;
                }
                if (side == EnumFacing.SOUTH) {
                    d2 = (double)z + axisalignedbb.field_72334_f + (double)0.1f;
                }
                if (side == EnumFacing.WEST) {
                    d0 = (double)x + axisalignedbb.field_72340_a - (double)0.1f;
                }
                if (side == EnumFacing.EAST) {
                    d0 = (double)x + axisalignedbb.field_72336_d + (double)0.1f;
                }
                Particle particle = new ParticleCustomDigging(world, d0, d1, d2, 0.0, 0.0, 0.0, state, pos, sprite).func_70543_e(0.2f).func_70541_f(0.6f);
                manager.func_78873_a(particle);
                return true;
            }
        }
        return false;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState stateAgain, EntityLivingBase entity, int numberOfParticles) {
        PacketCustomParticle packet = new PacketCustomParticle(pos, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.15f);
        PacketHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos)), packet);
        return true;
    }
}

