/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.gui;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.inferface.Talent;
import doggytalents.configuration.ConfigHandler;
import doggytalents.entity.EntityDog;
import doggytalents.entity.features.ModeFeature;
import doggytalents.network.PacketHandler;
import doggytalents.network.client.PacketDogMode;
import doggytalents.network.client.PacketDogName;
import doggytalents.network.client.PacketDogObey;
import doggytalents.network.client.PacketDogTalent;
import doggytalents.network.client.PacketDogTexture;
import doggytalents.network.client.PacketFriendlyFire;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class GuiDogInfo
extends GuiScreen {
    public EntityDog dog;
    public EntityPlayer player;
    private List<GuiTextField> textfieldList = new ArrayList<GuiTextField>();
    private GuiTextField nameTextField;
    public int doggyTex;
    private int currentPage = 0;
    private int maxPages = 1;
    public int btnPerPages = 0;
    private final DecimalFormat dfShort = new DecimalFormat("0.0");
    private final DecimalFormat dfShortDouble = new DecimalFormat("0.00");

    public GuiDogInfo(EntityDog dog, EntityPlayer player) {
        this.dog = dog;
        this.player = player;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_195124_j.clear();
        this.field_146293_o.clear();
        this.textfieldList.clear();
        super.func_73866_w_();
        this.field_146297_k.field_195559_v.func_197967_a(true);
        int topX = this.field_146294_l / 2;
        int topY = this.field_146295_m / 2;
        GuiTextField nameTextField = new GuiTextField(0, this.field_146289_q, topX - 100, topY + 50, 200, 20){

            public boolean charTyped(char character, int keyId) {
                boolean typed = super.charTyped(character, keyId);
                if (typed) {
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogName(GuiDogInfo.this.dog.func_145782_y(), this.func_146179_b()));
                }
                return typed;
            }

            public void func_146175_b(int index) {
                super.func_146175_b(index);
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogName(GuiDogInfo.this.dog.func_145782_y(), this.func_146179_b()));
            }
        };
        nameTextField.func_146195_b(false);
        nameTextField.func_146203_f(32);
        if (this.dog.func_145818_k_()) {
            nameTextField.func_146180_a(this.dog.func_200201_e().func_150261_e());
        }
        this.nameTextField = nameTextField;
        this.textfieldList.add(nameTextField);
        this.doggyTex = this.dog.getTameSkin();
        int size = DoggyTalentsAPI.TALENTS.getKeys().size();
        this.btnPerPages = Math.max(MathHelper.func_76128_c((double)((double)(Minecraft.func_71410_x().field_195558_d.func_198087_p() - 10) / 21.0)) - 2, 1);
        if (this.btnPerPages < size) {
            this.func_189646_b(new GuiButton(-1, 25, this.btnPerPages * 21 + 10, 20, 20, "<"){

                public void func_194829_a(double mouseX, double mouseY) {
                    if (GuiDogInfo.this.currentPage > 0) {
                        GuiDogInfo guiDogInfo = GuiDogInfo.this;
                        guiDogInfo.currentPage = guiDogInfo.currentPage - 1;
                        GuiDogInfo.this.func_73866_w_();
                    }
                }
            });
            this.func_189646_b(new GuiButton(-2, 48, this.btnPerPages * 21 + 10, 20, 20, ">"){

                public void func_194829_a(double mouseX, double mouseY) {
                    if (GuiDogInfo.this.currentPage + 1 < GuiDogInfo.this.maxPages) {
                        GuiDogInfo guiDogInfo = GuiDogInfo.this;
                        guiDogInfo.currentPage = guiDogInfo.currentPage + 1;
                        GuiDogInfo.this.func_73866_w_();
                    }
                }
            });
        }
        this.maxPages = MathHelper.func_76143_f((double)((double)size / (double)this.btnPerPages));
        if (this.currentPage >= this.maxPages) {
            this.currentPage = 0;
        }
        int i = -1;
        for (Talent talent : DoggyTalentsAPI.TALENTS.getValues()) {
            if (++i < this.currentPage * this.btnPerPages || i >= (this.currentPage + 1) * this.btnPerPages) continue;
            this.func_189646_b(new GuiTalentButton(1 + i, 25, 10 + (i - this.currentPage * this.btnPerPages) * 21, 20, 20, "+", talent){

                public void func_194829_a(double mouseX, double mouseY) {
                    int level = GuiDogInfo.this.dog.TALENTS.getLevel(this.talent);
                    if (level < this.talent.getHighestLevel(GuiDogInfo.this.dog) && GuiDogInfo.this.dog.spendablePoints() >= this.talent.getCost(GuiDogInfo.this.dog, level + 1)) {
                        PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogTalent(GuiDogInfo.this.dog.func_145782_y(), this.talent.getRegistryName()));
                    }
                }
            });
        }
        if (ConfigHandler.CLIENT.useDTTextures()) {
            this.func_189646_b(new GuiButton(-3, this.field_146294_l - 42, topY + 30, 20, 20, "+"){

                public void func_194829_a(double mouseX, double mouseY) {
                    ++GuiDogInfo.this.doggyTex;
                    GuiDogInfo.this.doggyTex %= 128;
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogTexture(GuiDogInfo.this.dog.func_145782_y(), GuiDogInfo.this.doggyTex));
                }
            });
            this.func_189646_b(new GuiButton(-4, this.field_146294_l - 64, topY + 30, 20, 20, "-"){

                public void func_194829_a(double mouseX, double mouseY) {
                    GuiDogInfo.this.doggyTex += 127;
                    GuiDogInfo.this.doggyTex %= 128;
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogTexture(GuiDogInfo.this.dog.func_145782_y(), GuiDogInfo.this.doggyTex));
                }
            });
        }
        if (this.dog.func_152114_e((EntityLivingBase)this.player)) {
            this.func_189646_b(new GuiButton(-5, this.field_146294_l - 64, topY + 65, 42, 20, String.valueOf(this.dog.willObeyOthers())){

                public void func_194829_a(double mouseX, double mouseY) {
                    this.field_146126_j = String.valueOf(!GuiDogInfo.this.dog.willObeyOthers());
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogObey(GuiDogInfo.this.dog.func_145782_y(), !GuiDogInfo.this.dog.willObeyOthers()));
                }
            });
        }
        this.func_189646_b(new GuiButton(-7, this.field_146294_l - 64, topY - 5, 42, 20, String.valueOf(this.dog.canFriendlyFire())){

            public void func_194829_a(double mouseX, double mouseY) {
                this.field_146126_j = String.valueOf(!GuiDogInfo.this.dog.canFriendlyFire());
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketFriendlyFire(GuiDogInfo.this.dog.func_145782_y(), !GuiDogInfo.this.dog.canFriendlyFire()));
            }
        });
        this.func_189646_b(new GuiButton(-6, topX + 40, topY + 25, 60, 20, I18n.func_135052_a((String)this.dog.MODE.getMode().getUnlocalisedName(), (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                int newMode = (GuiDogInfo.this.dog.MODE.getMode().ordinal() + 1) % ModeFeature.EnumMode.values().length;
                ModeFeature.EnumMode mode = ModeFeature.EnumMode.values()[newMode];
                this.field_146126_j = mode == ModeFeature.EnumMode.WANDERING && !GuiDogInfo.this.dog.COORDS.hasBowlPos() ? TextFormatting.RED + I18n.func_135052_a((String)mode.getUnlocalisedName(), (Object[])new Object[0]) : I18n.func_135052_a((String)mode.getUnlocalisedName(), (Object[])new Object[0]);
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogMode(GuiDogInfo.this.dog.func_145782_y(), newMode));
            }
        });
        this.textfieldList.stream().forEach(t -> this.field_195124_j.add(t));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int topX = this.field_146294_l / 2;
        int topY = this.field_146295_m / 2;
        String health = this.dfShort.format(this.dog.func_110143_aJ());
        String healthMax = this.dfShort.format(this.dog.func_110138_aP());
        String healthRel = this.dfShort.format(this.dog.getHealthRelative() * 100.0);
        String healthState = health + "/" + healthMax + " (" + healthRel + "%)";
        String speedValue = this.dfShortDouble.format(this.dog.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        String ageValue = this.dfShortDouble.format(this.dog.func_70874_b());
        String ageRel = "";
        ageRel = this.dog.func_70631_g_() ? I18n.func_135052_a((String)"doggui.age.baby", (Object[])new Object[0]) : I18n.func_135052_a((String)"doggui.age.adult", (Object[])new Object[0]);
        String ageString = ageValue + " " + ageRel;
        String tamedString = "";
        if (this.dog.func_70909_n()) {
            tamedString = this.dog.func_152114_e((EntityLivingBase)this.player) ? I18n.func_135052_a((String)"doggui.owner.you", (Object[])new Object[0]) : this.dog.getOwnersName().func_150254_d();
        }
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.health", (Object[])new Object[0]) + healthState, (float)(this.field_146294_l - 160), (float)(topY - 110), 0xFFFFFF);
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.speed", (Object[])new Object[0]) + speedValue, (float)(this.field_146294_l - 160), (float)(topY - 100), 0xFFFFFF);
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.owner", (Object[])new Object[0]) + tamedString, (float)(this.field_146294_l - 160), (float)(topY - 90), 0xFFFFFF);
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.age", (Object[])new Object[0]) + ageString, (float)(this.field_146294_l - 160), (float)(topY - 80), 0xFFFFFF);
        if (ConfigHandler.COMMON.dogGender()) {
            this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.gender", (Object[])new Object[0]) + I18n.func_135052_a((String)this.dog.GENDER.getGenderName(), (Object[])new Object[0]), (float)(this.field_146294_l - 160), (float)(topY - 70), 0xFFFFFF);
        }
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.newname", (Object[])new Object[0]), (float)(topX - 100), (float)(topY + 38), 0x404040);
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.level", (Object[])new Object[0]) + " " + this.dog.LEVELS.getLevel(), (float)(topX - 65), (float)(topY + 75), 16716025);
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.leveldire", (Object[])new Object[0]) + " " + this.dog.LEVELS.getDireLevel(), (float)topX, (float)(topY + 75), 16716025);
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.pointsleft", (Object[])new Object[0]) + " " + this.dog.spendablePoints(), (float)(topX - 38), (float)(topY + 89), 0xFFFFFF);
        if (ConfigHandler.CLIENT.useDTTextures()) {
            this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.textureindex", (Object[])new Object[0]), (float)(this.field_146294_l - 80), (float)(topY + 20), 0xFFFFFF);
        }
        if (this.dog.func_152114_e((EntityLivingBase)this.player)) {
            this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.obeyothers", (Object[])new Object[0]), (float)(this.field_146294_l - 76), (float)(topY + 55), 0xFFFFFF);
        }
        this.field_146289_q.func_211126_b(I18n.func_135052_a((String)"doggui.friendlyfire", (Object[])new Object[0]), (float)(this.field_146294_l - 76), (float)(topY - 15), 0xFFFFFF);
        int i = -1;
        for (Talent talent : DoggyTalentsAPI.TALENTS.getValues()) {
            if (++i < this.currentPage * this.btnPerPages || i >= (this.currentPage + 1) * this.btnPerPages) continue;
            this.field_146289_q.func_211126_b(I18n.func_135052_a((String)talent.getTranslationKey(), (Object[])new Object[0]), 50.0f, (float)(17 + (i - this.currentPage * this.btnPerPages) * 21), 0xFFFFFF);
        }
        for (GuiTextField field : this.textfieldList) {
            field.func_195608_a(mouseX, mouseY, partialTicks);
        }
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton button = (GuiButton)this.field_146292_n.get(k);
            if (!button.func_146115_a()) continue;
            ArrayList<String> list = new ArrayList<String>();
            if (button.field_146127_k >= 1 && button.field_146127_k <= DoggyTalentsAPI.TALENTS.getKeys().size()) {
                Talent talent = button instanceof GuiTalentButton ? ((GuiTalentButton)button).talent : null;
                list.add(TextFormatting.GREEN + I18n.func_135052_a((String)talent.getTranslationKey(), (Object[])new Object[0]));
                list.add("Level: " + this.dog.TALENTS.getLevel(talent));
                list.add(TextFormatting.GRAY + "--------------------------------");
                list.addAll(this.splitInto(I18n.func_135052_a((String)talent.getInfoTranslationKey(), (Object[])new Object[0]), 200, this.field_146297_k.field_71466_p));
            }
            if (button.field_146127_k == -1) {
                list.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"doggui.prevpage", (Object[])new Object[0]));
            } else if (button.field_146127_k == -2) {
                list.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"doggui.nextpage", (Object[])new Object[0]));
            } else if (button.field_146127_k == -6) {
                String str = I18n.func_135052_a((String)this.dog.MODE.getMode().getUnlocalisedInfo(), (Object[])new Object[0]);
                list.addAll(this.splitInto(str, 150, this.field_146297_k.field_71466_p));
                if (this.dog.MODE.isMode(ModeFeature.EnumMode.WANDERING)) {
                    if (!this.dog.COORDS.hasBowlPos()) {
                        list.add(TextFormatting.RED + I18n.func_135052_a((String)"dog.mode.docile.nobowl", (Object[])new Object[0]));
                    } else if (this.dog.func_174818_b(this.dog.COORDS.getBowlPos()) > 256.0) {
                        list.add(TextFormatting.RED + I18n.func_135052_a((String)"dog.mode.docile.distance", (Object[])new Object[]{(int)Math.sqrt(this.dog.func_180425_c().func_177951_i((Vec3i)this.dog.COORDS.getBowlPos()))}));
                    } else {
                        list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"dog.mode.docile.bowl", (Object[])new Object[]{(int)Math.sqrt(this.dog.func_180425_c().func_177951_i((Vec3i)this.dog.COORDS.getBowlPos()))}));
                    }
                }
            }
            this.drawHoveringText(list, mouseX, mouseY, this.field_146297_k.field_71466_p);
        }
        GlStateManager.func_179121_F();
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiTextField field : this.textfieldList) {
            field.func_146178_a();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.field_146297_k.field_195559_v.func_197967_a(false);
    }

    public boolean func_73868_f() {
        return false;
    }

    public List<String> splitInto(String text, int maxLength, FontRenderer font) {
        ArrayList<String> list = new ArrayList<String>();
        String temp = "";
        String[] split = text.split(" ");
        for (int i = 0; i < split.length; ++i) {
            String str = split[i];
            int length = font.func_78256_a(temp + str);
            if (length > maxLength) {
                list.add(temp);
                temp = "";
            }
            temp = temp + str + " ";
            if (i != split.length - 1) continue;
            list.add(temp);
        }
        return list;
    }

    private static class GuiTalentButton
    extends GuiButton {
        protected Talent talent;

        private GuiTalentButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Talent talent) {
            super(buttonId, x, y, widthIn, heightIn, buttonText);
            this.talent = talent;
        }
    }
}

