/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.model.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import doggytalents.api.registry.DogBedRegistry;
import doggytalents.block.BlockDogBed;
import doggytalents.client.model.block.DogBedItemOverride;
import doggytalents.client.model.block.IStateParticleModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class DogBedModel
implements IBakedModel,
IStateParticleModel {
    public static DogBedItemOverride ITEM_OVERIDE = new DogBedItemOverride();
    private ModelBlock model;
    private IBakedModel bakedModel;
    private final VertexFormat format;
    private final Map<Map<String, EnumFacing>, IBakedModel> cache = Maps.newHashMap();

    public DogBedModel(ModelBlock model, IBakedModel bakedModel, VertexFormat format) {
        this.model = model;
        this.bakedModel = bakedModel;
        this.format = format;
    }

    public IBakedModel getCustomModelFromState(IBlockState state) {
        String casing = "minecraft:block/oak_planks";
        String bedding = "minecraft:block/white_wool";
        EnumFacing facing = EnumFacing.NORTH;
        if (state != null) {
            facing = (EnumFacing)state.func_177229_b((IProperty)BlockDogBed.FACING);
            casing = DogBedRegistry.CASINGS.getTexture(state, BlockDogBed.CASING);
            bedding = DogBedRegistry.BEDDINGS.getTexture(state, BlockDogBed.BEDDING);
        }
        return this.getCustomModel(casing, bedding, facing);
    }

    public IBakedModel getCustomModel(String casingResource, String beddingResource, EnumFacing facing) {
        IBakedModel customModel = this.bakedModel;
        if (casingResource == null) {
            casingResource = "nomissing";
        }
        if (beddingResource == null) {
            beddingResource = "nomissing";
        }
        if (facing == null) {
            facing = EnumFacing.NORTH;
        }
        HashMap cacheKey = Maps.newHashMap();
        cacheKey.put(beddingResource + casingResource, facing);
        if (this.cache.containsKey(cacheKey)) {
            customModel = this.cache.get(cacheKey);
        } else if (this.model != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"bedding", (Object)beddingResource);
            builder.put((Object)"casing", (Object)casingResource);
            builder.put((Object)"particle", (Object)casingResource);
            ImmutableMap textures = builder.build();
            ArrayList elements = Lists.newArrayList();
            for (BlockPart part : this.model.func_178298_a()) {
                elements.add(new BlockPart(part.field_178241_a, part.field_178239_b, (Map)Maps.newHashMap((Map)part.field_178240_c), part.field_178237_d, part.field_178238_e));
            }
            ModelBlock newModel = new ModelBlock(this.model.getParentLocation(), (List)elements, (Map)Maps.newHashMap((Map)this.model.field_178318_c), this.model.func_178309_b(), this.model.func_178311_c(), this.model.func_181682_g(), (List)Lists.newArrayList((Iterable)this.model.func_187966_f()));
            newModel.field_178317_b = this.model.field_178317_b;
            newModel.field_178315_d = this.model.field_178315_d;
            newModel.field_178318_c.put("bedding", beddingResource);
            newModel.field_178318_c.put("casing", casingResource);
            newModel.field_178318_c.put("particle", casingResource);
            customModel = newModel.bake(ModelLoader.defaultModelGetter(), ModelLoader.defaultTextureGetter(), (IModelState)TRSRTransformation.getRotation((EnumFacing)facing), true, this.format);
            this.cache.put(cacheKey, customModel);
        }
        return customModel;
    }

    public List<BakedQuad> func_200117_a(IBlockState state, EnumFacing side, Random rand) {
        return this.getCustomModelFromState(state).func_200117_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.bakedModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.bakedModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.bakedModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.bakedModel.func_177552_f();
    }

    @Override
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        return this.getCustomModelFromState(state).func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ITEM_OVERIDE;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)this.bakedModel.handlePerspective(cameraTransformType).getRight());
    }
}

