/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.renderer.entity;

import doggytalents.ModTalents;
import doggytalents.client.model.entity.ModelChest;
import doggytalents.client.model.entity.ModelDog;
import doggytalents.client.model.entity.ModelSaddle;
import doggytalents.client.model.entity.ModelWings;
import doggytalents.client.renderer.RenderUtil;
import doggytalents.client.renderer.entity.layer.LayerBone;
import doggytalents.client.renderer.entity.layer.LayerCape;
import doggytalents.client.renderer.entity.layer.LayerCover;
import doggytalents.client.renderer.entity.layer.LayerDogCollar;
import doggytalents.client.renderer.entity.layer.LayerDogHurt;
import doggytalents.client.renderer.entity.layer.LayerModel;
import doggytalents.client.renderer.entity.layer.LayerRadioCollar;
import doggytalents.configuration.ConfigHandler;
import doggytalents.entity.EntityDog;
import doggytalents.lib.ResourceLib;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.model.ModelBase;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderDog
extends RenderLiving<EntityDog> {
    public RenderDog(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelDog(0.0f), 0.5f);
        this.func_177094_a(new LayerCape(this));
        this.func_177094_a(new LayerRadioCollar(this));
        this.func_177094_a(new LayerDogCollar(this));
        this.func_177094_a(new LayerDogHurt(this));
        this.func_177094_a(new LayerBone(this));
        this.func_177094_a(new LayerCover(this, (ModelBase)new ModelDog(0.4f), ResourceLib.MOB_LAYER_SUNGLASSES, EntityDog::hasSunglasses));
        this.func_177094_a(new LayerModel(this, new ModelDog(0.4f), ResourceLib.MOB_LAYER_ARMOR, dog -> ConfigHandler.CLIENT.doggyArmour() && dog.TALENTS.getLevel(ModTalents.GUARD_DOG) > 0));
        this.func_177094_a(new LayerModel(this, new ModelWings(), ResourceLib.MOB_LAYER_WINGS, dog -> ConfigHandler.CLIENT.doggyWings() && dog.TALENTS.getLevel(ModTalents.PILLOW_PAW) == 5));
        this.func_177094_a(new LayerModel(this, new ModelSaddle(0.0f), ResourceLib.MOB_LAYER_SADDLE, dog -> ConfigHandler.CLIENT.doggySaddle() && dog.TALENTS.getLevel(ModTalents.WOLF_MOUNT) > 0));
        this.func_177094_a(new LayerModel(this, new ModelChest(0.0f), ResourceLib.MOB_LAYER_CHEST, dog -> ConfigHandler.CLIENT.doggyChest() && dog.TALENTS.getLevel(ModTalents.PACK_PUPPY) > 0));
    }

    protected float handleRotationFloat(EntityDog dog, float partialTickTime) {
        return dog.getTailRotation();
    }

    protected void renderLivingAt(EntityDog dog, double x, double y, double z) {
        if (dog.func_70089_S() && dog.func_70608_bn()) {
            super.func_77039_a((EntityLivingBase)dog, x, y + 0.5, z);
        } else {
            super.func_77039_a((EntityLivingBase)dog, x, y, z);
        }
    }

    public void doRender(EntityDog dog, double x, double y, double z, float entityYaw, float partialTicks) {
        if (dog.isDogWet()) {
            float f2 = dog.func_70013_c() * dog.getShadingWhileWet(partialTicks);
            GlStateManager.func_179124_c((float)f2, (float)f2, (float)f2);
        }
        super.func_76986_a((EntityLiving)dog, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityDog dog) {
        if (ConfigHandler.CLIENT.useDTTextures()) {
            return ResourceLib.getTameSkin(dog.getTameSkin());
        }
        return ResourceLib.MOB_DOG_TAME;
    }

    public void renderName(EntityDog dog, double x, double y, double z) {
        if (this.func_177070_b((EntityLiving)dog)) {
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = dog.func_70068_e(this.field_76990_c.field_78734_h);
            y += (double)((float)this.func_76983_a().field_78288_b * 1.15f * 0.016666668f * 0.7f);
            String tip = dog.MODE.getMode().getTip();
            if (dog.isIncapacicated()) {
                tip = "dog.mode.incapacitated.indicator";
            }
            String label = String.format("%s(%d)%s", new TextComponentTranslation(tip, new Object[0]).func_150254_d(), dog.getDogHunger(), new TextComponentTranslation(dog.GENDER.getGenderTip(), new Object[0]).func_150254_d());
            if (d0 <= 4096.0) {
                boolean flag = dog.func_70093_af();
                float f = this.field_76990_c.field_78735_i;
                float f1 = this.field_76990_c.field_78732_j;
                boolean flag1 = this.field_76990_c.field_78733_k.field_74320_O == 2;
                float f2 = dog.field_70131_O + 0.42f - (flag ? 0.25f : 0.0f) - (dog.func_70608_bn() ? 0.5f : 0.0f);
                RenderUtil.renderLabelWithScale(this.func_76983_a(), label, (float)x, (float)y + f2, (float)z, 0, f, f1, flag1, flag, 0.01f);
                RenderUtil.renderLabelWithScale(this.func_76983_a(), dog.func_145748_c_().func_150254_d(), (float)x, (float)y + f2 - 0.12f, (float)z, 0, f, f1, flag1, flag, 0.026f);
                if (d0 <= 25.0 && this.field_76990_c.field_78734_h.func_70093_af()) {
                    String ownerName = dog.getOwnersName().func_150254_d();
                    RenderUtil.renderLabelWithScale(this.func_76983_a(), ownerName, (float)x, (float)y + f2 - 0.34f, (float)z, 0, f, f1, flag1, flag, 0.01f);
                }
            }
        }
    }

    protected void preRenderCallback(EntityDog entitylivingbaseIn, float partialTickTime) {
        EntityDog dog = entitylivingbaseIn;
        float size = (float)dog.getDogSize() * 0.3f + 0.1f;
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        this.field_76989_e = size * 0.5f;
    }
}

