/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class DTClientConfig {
    public ForgeConfigSpec.BooleanValue DIRE_PARTICLES;
    public ForgeConfigSpec.BooleanValue RENDER_BLOOD;
    public ForgeConfigSpec.BooleanValue DOGGY_WINGS;
    public ForgeConfigSpec.BooleanValue DOGGY_CHEST;
    public ForgeConfigSpec.BooleanValue DOGGY_SADDLE;
    public ForgeConfigSpec.BooleanValue USE_DT_TEXTURES;
    public ForgeConfigSpec.BooleanValue DOGGY_ARMOUR;

    public DTClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("General");
        builder.pop();
        builder.push("Dog Settings");
        this.DIRE_PARTICLES = builder.comment("Enables the particle effect on Dire Level 30 dogs.").define("direParticles", true);
        this.RENDER_BLOOD = builder.comment("When enabled, Dogs will show blood texture while incapacitated.").define("bloodWhenIncapacitated", true);
        this.DOGGY_WINGS = builder.comment("When enabled, Dogs will have wings when at level 5 pillow paw.").define("doggyWings", true);
        this.DOGGY_CHEST = builder.comment("When enabled, dogs with points in pack puppy will have chests on their side.").define("doggyChest", true);
        this.DOGGY_SADDLE = builder.comment("When enabled, dogs with points in wolf mount will have a saddle on.").define("doggySaddle", true);
        this.USE_DT_TEXTURES = builder.comment("If disabled will use the default minecraft wolf skin for all dog textures.").define("useDTTextures", true);
        this.DOGGY_ARMOUR = builder.comment("When enabled, dogs with points in guard dog will have armour.").define("doggyArmour", false);
        builder.pop();
    }

    public boolean direParticles() {
        return (Boolean)this.DIRE_PARTICLES.get();
    }

    public boolean renderBlood() {
        return (Boolean)this.RENDER_BLOOD.get();
    }

    public boolean doggyWings() {
        return (Boolean)this.DOGGY_WINGS.get();
    }

    public boolean doggyChest() {
        return (Boolean)this.DOGGY_CHEST.get();
    }

    public boolean doggySaddle() {
        return (Boolean)this.DOGGY_SADDLE.get();
    }

    public boolean useDTTextures() {
        return (Boolean)this.USE_DT_TEXTURES.get();
    }

    public boolean doggyArmour() {
        return (Boolean)this.DOGGY_ARMOUR.get();
    }
}

