/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.configuration;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class DTCommonConfig {
    public ForgeConfigSpec.BooleanValue DEBUG_MODE;
    public ForgeConfigSpec.BooleanValue DOGS_IMMORTAL;
    public ForgeConfigSpec.BooleanValue TEN_DAY_PUPS;
    public ForgeConfigSpec.BooleanValue IS_HUNGER_ON;
    public ForgeConfigSpec.BooleanValue STARTING_ITEMS;
    public ForgeConfigSpec.BooleanValue DOG_GENDER;
    public ForgeConfigSpec.BooleanValue DOG_WHINE_WHEN_HUNGER_LOW;
    public ForgeConfigSpec.BooleanValue PUPS_GET_PARENT_LEVELS;
    public Map<String, ForgeConfigSpec.BooleanValue> DISABLED_TALENTS;

    public DTCommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("General");
        this.DEBUG_MODE = builder.comment("Enables debugging mode, which would output values for the sake of finding issues in the mod.").define("debugMode", false);
        builder.pop();
        builder.push("Dog Settings");
        this.DOGS_IMMORTAL = builder.comment("Determines if dogs die when their health reaches zero. If true, dogs will not die, and will instead become incapacitated.").define("isDogImmortal", true);
        this.TEN_DAY_PUPS = builder.comment("Determines if pups take 10 days to mature.").define("tenDayPuppies", true);
        this.IS_HUNGER_ON = builder.comment("Enables hunger mode for the dog").define("isHungerOn", true);
        this.STARTING_ITEMS = builder.comment("When enabled you will spawn with a guide, Doggy Charm and Command Emblem.").define("isStartingItemsEnabled", false);
        this.DOG_GENDER = builder.comment("When enabled, dogs will be randomly assigned genders and will only mate and produce children with the opposite gender.").define("dogGender", false);
        this.DOG_WHINE_WHEN_HUNGER_LOW = builder.comment("Determines if dogs should whine when hunger reaches below 20 DP.").define("shouldWhineWhenStarving", true);
        this.PUPS_GET_PARENT_LEVELS = builder.comment("When enabled, puppies get some levels from parents. When disabled, puppies start at 0 points.").define("pupsGetParentLevel", false);
        builder.pop();
        builder.push("Talents");
        String[] talentIds = new String[]{"doggytalents:bed_finder", "doggytalents:black_pelt", "doggytalents:creeper_sweeper", "doggytalents:doggy_dash", "doggytalents:fisher_dog", "doggytalents:guard_dog", "doggytalents:happy_eater", "doggytalents:hell_hound", "doggytalents:hunter_dog", "doggytalents:pack_puppy", "doggytalents:pest_fighter", "doggytalents:pillow_paw", "doggytalents:poison_fang", "doggytalents:puppy_eyes", "doggytalents:quick_healer", "doggytalents:rescue_dog", "doggytalents:roaring_gale", "doggytalents:shepherd_dog", "doggytalents:swimmer_dog", "doggytalents:wolf_mount"};
        this.DISABLED_TALENTS = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        for (String talentId : talentIds) {
            this.DISABLED_TALENTS.put(talentId, builder.define(talentId, true));
        }
        builder.pop();
    }

    public boolean debugMode() {
        return (Boolean)this.DEBUG_MODE.get();
    }

    public boolean dogsImmortal() {
        return (Boolean)this.DOGS_IMMORTAL.get();
    }

    public boolean tenDayPups() {
        return (Boolean)this.TEN_DAY_PUPS.get();
    }

    public boolean hungerOn() {
        return (Boolean)this.IS_HUNGER_ON.get();
    }

    public boolean startingItems() {
        return (Boolean)this.STARTING_ITEMS.get();
    }

    public boolean dogGender() {
        return (Boolean)this.DOG_GENDER.get();
    }

    public boolean whineWhenHungerLow() {
        return (Boolean)this.DOG_WHINE_WHEN_HUNGER_LOW.get();
    }

    public boolean pupsGetParentLevels() {
        return (Boolean)this.PUPS_GET_PARENT_LEVELS.get();
    }

    public boolean isTalentDisabled(String talentId) {
        ForgeConfigSpec.BooleanValue entry = this.DISABLED_TALENTS.get(talentId);
        return entry != null && (Boolean)entry.get() == false;
    }
}

